/*++CmdGenerateUIDOptionsParam.java+++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.NaturalNumberParam;
import  edu.washington.cac.calendar.icalendar.ICalendarException;
								/* for main */


/**
 * CAP (CMD GENERATE-UID) OPTIONS parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	10.2 [CAP/09]
 *   occurs:	0-1 (CMD/GENERATE-UID)
 *   datatypes:	INTEGER/natural number (1)
 *   default:	---
 *   allowed:	>= 1???
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2002/12/10 slh
 */
public
class  CmdGenerateUIDOptionsParam
extends  NaturalNumberParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  public
  CmdGenerateUIDOptionsParam  (		)
  {
    super( Names.strParam_Options );
  }


  public
  CmdGenerateUIDOptionsParam  (String	strValue	)
  {
    super( Names.strParam_Options , strValue );
  }


  public
  CmdGenerateUIDOptionsParam  (int	iValue	)
  {
    super( Names.strParam_Options , iValue );
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    CmdGenerateUIDOptionsParam	cmdgenerateuidoptionsparam	=
					new CmdGenerateUIDOptionsParam(  );

    /*void*/System.out.println( cmdgenerateuidoptionsparam );

    /*void*/cmdgenerateuidoptionsparam.set( 9 );
    /*void*/System.out.println( cmdgenerateuidoptionsparam );

    try {
      /*void*/System.out.println( cmdgenerateuidoptionsparam.get(  ) );
    } catch (ICalendarException	e	) {
      /*void*/System.out.println( "\t" + e );
    }

    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/cmdgenerateuidoptionsparam.set( 0 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println( cmdgenerateuidoptionsparam );
  }

}


/* Log:
 *  0.00  2002/12/09 - 2002/12/10 slh
 *        create from LatencyParam.java
 */
/*--CmdGenerateUIDOptionsParam.java-----------------------------------------*/
