/*++CmdDeleteOptionsParam.java++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.util.HashMap;

import  edu.washington.cac.calendar.icalendar.EnumParam;


/**
 * CAP (CMD DELETE) OPTIONS parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	10.1.5 [CAP/09]
 *   occurs:	0-1 (CMD/DELETE)
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	"MARK"
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2002/12/09 slh
 */
public
class  CmdDeleteOptionsParam
extends  EnumParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a (CMD DELETE) OPTION parameter.
   */
  public
  CmdDeleteOptionsParam  (		)
  {
    super( Names.strParam_Options );
  }


  /**
   * Create a (CMD DELETE) OPTIONS set to supplied id value.
   */
  public
  CmdDeleteOptionsParam  (int	iValue	)
  {
    super( Names.strParam_Options , iValue );
  }


  /**
   * Create a (CMD DELETE) OPTIONS parameter set to supplied string value.
   */
  public
  CmdDeleteOptionsParam  (String	strValue	)
  {
    super( Names.strParam_Options , strValue );
  }


/*----------------------------------------------------------------------------
 *						Class Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    m_hmValue.put( new Integer( MARK ) , Names.strValue_Mark );

    /* no default */
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	MARK		=  1;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    CmdDeleteOptionsParam	cmddeleteoptionsparam	=
						new CmdDeleteOptionsParam(  );

    /*void*/System.out.println( cmddeleteoptionsparam );

    try {
      /*void*/cmddeleteoptionsparam.set( CmdDeleteOptionsParam.MARK );
      /*void*/System.out.println( cmddeleteoptionsparam );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( cmddeleteoptionsparam.get(  ) );
    /*void*/System.out.println( cmddeleteoptionsparam.getEnum(  ) );

    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/cmddeleteoptionsparam.set( 666 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/cmddeleteoptionsparam.set( "six six six" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println( cmddeleteoptionsparam );
  }

}


/* Log:
 *  0.00  2002/12/09  slh
 *        create
 */
/*--CmdDeleteOptionsParam.java----------------------------------------------*/
