/*++Cmd.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.util.HashMap;
import  java.util.Vector;

import  edu.washington.cac.calendar.icalendar.EnumProp;
import  edu.washington.cac.calendar.icalendar.Parameter;
import  edu.washington.cac.calendar.icalendar.XParam;
import  edu.washington.cac.calendar.icalendar.InvalidParameterException;
import  edu.washington.cac.calendar.icalendar.ICalendarException;


/**
 * CAP CMD property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	10 [CAP/09]
 *   occurs:	0-1 (any)
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	"ABORT", "CONTINUE", "CREATE", "DELETE", "GENERATE-UID",
 *		"GET-CAPABILITY", "IDENTIFY", "MODIFY", "MOVE", "REPLY",
 *		"SEARCH", "SET-LOCALE", "TIMEOUT"
 *   params:	ID(0-1), LOCALIZE(0-1), LATENCY(0-1), ACTION(0-1),
 *		OPTIONS(0-1)
 *
 * Command/Parameters Combinations Allowed:
 *   command/parameter	id	local.	latency	options
 *					/action	(#occur)
 *   ABORT		y	y	n	(0)
 *   CONTINUE		y	y	y	(0)
 *   CREATE		y	y	y	(0)
 *   DELETE		y	y	y	MARK(0-1)
 *   GENERATE-UID	y	y	y	int(1)
 *   GET-CAPABILITY	y	y	y	(0)
 *   IDENTIFY		y	y	y	upn(0-1)
 *   MODIFY		y	y	y	(0)
 *   MOVE		y	y	y	(0)
 *   REPLY		y	n	n	(0)
 *   SEARCH		y	y	y	(0)
 *   SET-LOCALE		y	y	y	local(0-1)
 *   TIMEOUT		y	y	n	(0)
 *
 * CUA/CS Implementation:
 *			direct.	CS	CUA	notes
 *   command			implem.	implem.
 *   ABORT		<->	???
 *   CONTINUE		<->	???
 *   CREATE		->cs	must
 *   DELETE		->cs	must
 *   GENERATE-UID	->cs	must
 *   GET-CAPABILITY	<->	must	may	cua may return not implemented
 *   IDENTIFY		->cs	must		cs may reject
 *   MODIFY		->cs	must
 *   MOVE		->cs	must
 *   REPLY		<->	must	may	cua for GET-CAPABILITY
 *   SEARCH		->cs	must
 *   SET-LOCALE		->cs	must
 *   TIMEOUT		<->	must	may	cua for GET-CAPABILITY
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/02/04 slh
 */
public
class  Cmd
extends  EnumProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a CMD property set to the default value.
   *
   * This is equivalent to Cmd( VAgenda.NONE );
   * meaning all parameters are allowed.
   */
  public
  Cmd  (		)
  {
    this( NONE );
  }


  /**
   * Create a CMD property set to supplied value.
   */
  public
  Cmd  (String	strValue	)
  {
    super( Names.strProp_Cmd , strValue );
  }


  /**
   * Create a CMD property set to supplied value.
   */
  public
  Cmd  (int	iValue	)
  {
    super( Names.strProp_Cmd , iValue );
  }


/*----------------------------------------------------------------------------
 *						Object Public Methods
 *--------------------------------------------------------------------------*/

  public
  boolean
  isComplete  (		)
  {
    /* if LATENCY and ACTION are not both either present or absent... */
    if (m_parameters.getCount( Names.strParam_Latency ) !=
	m_parameters.getCount( Names.strParam_Action )) {
      return false;						/*RETURN*/
    }

    return super.isComplete(  );				/*RETURN*/
  }


  public
  boolean
  isSupported  (		)
  {
//???on a cmd-basis
    switch (m_iValue) {
    case ABORT:
    case CONTINUE:
    case CREATE:
    case DELETE:
    case GENERATEUID:
    case GETCAPABILITY:
    case IDENTIFY:
    case MODIFY:
    case MOVE:
    case REPLY:
    case SEARCH:
    case SETLOCALE:
    case TIMEOUT:
    case NONE:
    default:
    }

    return false;
  }


  public
  void
  setEnum  (int	iValue	)
  throws Exception
  {
    /*void*/super.setEnum( iValue );

    /*void*/configProperty( m_iValue );
    /*void*/setupProperty(  );
  }


  public
  void
  set  (int	iValue	)
  throws Exception
  {
    /*void*/setEnum( iValue );
  }


  public
  void
  set  (String	strValue	)
  throws Exception
  {
    /*void*/super.set( strValue );

    /*void*/configProperty( m_iValue );
    /*void*/setupProperty(  );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding Property.configProperty()
    which is called in Property.Property(*).
  */
  protected
  void
  configProperty  (		)
  {
    /* do nothing - as proper config is not yet known */
  }


  /*Note: not overriding Property.configProperty()
    and not called in Property.Property(*) (as this has a different sig).
  */
  protected
  void
  configProperty  (int	iType	)
  {
    m_vParamZeroOne = new Vector(  );
    m_vParamZeroPlus = new Vector(  );

    /*void*/m_vParamZeroOne.add( IDParam.class );

    /*void*/m_vParamZeroPlus.add( XParam.class );

    switch (iType) {
    case REPLY:
      /* not allowed for this */
      break;
    case NONE:
    default:
      /*void*/m_vParamZeroOne.add( LocalizeParam.class );
      break;
    }

    switch (iType) {
    case ABORT:
    case REPLY:
    case TIMEOUT:
      /* not allowed for these */
      break;
    case NONE:
    default:
      /*void*/m_vParamZeroOne.add( LatencyParam.class );
      /*void*/m_vParamZeroOne.add( ActionParam.class );
      break;
    }

    switch (iType) {
    case DELETE:
    case IDENTIFY:
    case SETLOCALE:
    case NONE:
      /*void*/m_vParamZeroOne.add( OptionsParam.class );
      break;
    case GENERATEUID:
      m_vParamOne = new Vector(  );
      /*void*/m_vParamOne.add( OptionsParam.class );
      break;
    default:
      break;
    }
  }


  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    m_hmValue.put( new Integer( ABORT )		, Names.strCmd_Abort );
    m_hmValue.put( new Integer( CONTINUE )	, Names.strCmd_Continue );
    m_hmValue.put( new Integer( CREATE )	, Names.strCmd_Create );
    m_hmValue.put( new Integer( DELETE )	, Names.strCmd_Delete );
    m_hmValue.put( new Integer( GENERATEUID )	, Names.strCmd_GenerateUID );
    m_hmValue.put( new Integer( GETCAPABILITY ) ,
		   Names.strCmd_GetCapability );
    m_hmValue.put( new Integer( IDENTIFY )	, Names.strCmd_Identify );
    m_hmValue.put( new Integer( MODIFY )	, Names.strCmd_Modify );
    m_hmValue.put( new Integer( MOVE )		, Names.strCmd_Move );
    m_hmValue.put( new Integer( REPLY )		, Names.strCmd_Reply );
    m_hmValue.put( new Integer( SEARCH )	, Names.strCmd_Search );
    m_hmValue.put( new Integer( SETLOCALE )	, Names.strCmd_SetLocale );
    m_hmValue.put( new Integer( TIMEOUT )	, Names.strCmd_TimeOut );

    /* no default */
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	ABORT		=  1;
  final static public  int	CONTINUE	=  2;
  final static public  int	CREATE		=  3;
  final static public  int	DELETE		=  4;
  final static public  int	GENERATEUID	=  5;
  final static public  int	GETCAPABILITY	=  6;
  final static public  int	IDENTIFY	=  7;
  final static public  int	MODIFY		=  8;
  final static public  int	MOVE		=  9;
  final static public  int	REPLY		= 10;
  final static public  int	SEARCH		= 11;
  final static public  int	SETLOCALE	= 12;
  final static public  int	TIMEOUT		= 13;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    Cmd		cmd		= new Cmd(  );
    IDParam	idparam		= new IDParam(  );
    LocalizeParam	localizeparam	= new LocalizeParam(  );
    LatencyParam	latencyparam	= new LatencyParam(  );
    ActionParam		actionparam	= new ActionParam(  );
    OptionsParam	optionsparam;
    XParam	xparam		= new XParam( "X-SLH-NAME" );

    /*void*/System.out.println( "isComplete: " + cmd.isComplete(  ) );
    /*void*/System.out.println( "isSupported: " + cmd.isSupported(  ) );
    /*void*/System.out.println( cmd );

    try {
      cmd = new Cmd( Cmd.DELETE );
      optionsparam = new OptionsParam( "MARK" );
      /*void*/optionsparam.setType( Cmd.DELETE );
      /*void*/cmd.addParameter( optionsparam );
      /*void*/System.out.println( "isSupported: " + cmd.isSupported(  ) );
      /*void*/System.out.println( cmd );

      cmd = new Cmd( Cmd.GENERATEUID );
      optionsparam = new OptionsParam( "4" );
      /*void*/optionsparam.setType( Cmd.GENERATEUID );
      /*void*/cmd.addParameter( optionsparam );
      /*void*/System.out.println( "isSupported: " + cmd.isSupported(  ) );
      /*void*/System.out.println( cmd );

      cmd = new Cmd( Cmd.IDENTIFY );
      optionsparam = new OptionsParam( "slh@slh.net" );
      /*void*/optionsparam.setType( Cmd.IDENTIFY );
      /*void*/cmd.addParameter( optionsparam );
      /*void*/System.out.println( "isSupported: " + cmd.isSupported(  ) );
      /*void*/System.out.println( cmd );

      cmd = new Cmd( Cmd.SETLOCALE );
      optionsparam = new OptionsParam( "en_US" );
      /*void*/optionsparam.setType( Cmd.SETLOCALE );
      /*void*/cmd.addParameter( optionsparam );
      /*void*/System.out.println( "isSupported: " + cmd.isSupported(  ) );
      /*void*/System.out.println( cmd );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    try {
      /*void*/idparam.set( "some id" );
      /*void*/cmd.addParameter( idparam );
      /*void*/localizeparam.set( "some locale" );
      /*void*/cmd.addParameter( localizeparam );
      /*void*/System.out.println( cmd );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    try {
      /*void*/System.out.println( "isComplete: " + cmd.isComplete(  ) );
      /*void*/System.out.println( cmd );
      /*void*/latencyparam.set( 666 );
      /*void*/cmd.addParameter( latencyparam );
      /*void*/System.out.println( "isComplete: " + cmd.isComplete(  ) );
      /*void*/System.out.println( cmd );
      /*void*/actionparam.set( ActionParam.ABORT );
      /*void*/cmd.addParameter( actionparam );
      /*void*/System.out.println( "isComplete: " + cmd.isComplete(  ) );
      /*void*/System.out.println( cmd );
      /*void*/xparam.set( "xvalue" );
      /*void*/cmd.addParameter( xparam );
      /*void*/System.out.println( "isComplete: " + cmd.isComplete(  ) );
      /*void*/System.out.println( cmd );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( cmd.get(  ) );
    /*void*/System.out.println( cmd.getEnum(  ) );

    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/cmd.set( 666 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/cmd.set( "six six six" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println( cmd );
  }

}


/* Log:
 *  0.10  2003/01/08, 2003/02/04  slh
 *        (new year, new version...)
 *        Cmd*OptionsParam -> OptionsParam
 *        call setupProperty()
 *        NONE type and is default
 *        use .class to get class
 *  0.00  2002/10/23, 2002/10/29, 2002/12/09 - 2002/12/11  slh
 *        create
 */
/*--Cmd.java----------------------------------------------------------------*/
