/*++CalQueryProp.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.UnsupProp;


/**
 * Base class for CAP CAL-QUERY-valued properties.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	6.1.1 [CAP/09]
 *</PRE>
 *
 * Currently just a wrapper for UnsupProp.
 *
 * @author  slh
 * @version  0.00 2002/12/10 slh
 */
abstract public
class  CalQueryProp
extends  UnsupProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /*Note: attempting to use the default constructor is wrong*/


  /**
   * Create a CAL-QUERY property unset.
   */
  protected
  CalQueryProp  (String	strName	)
  {
    super( strName );
  }


  /**
   * Create a CAL-QUERY property set to supplied value.
   */
  protected
  CalQueryProp  (String	strName		,
		 String	strValue	)
  {
    super( strName , strValue );
  }

}


/* Log:
 *  0.00  2002/12/02, 2002/12/10  slh
 *        create
 */
/*--CalQueryProp.java-------------------------------------------------------*/
