/*++CalMaster.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.URIProp;


/**
 * CAP CALMASTER property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	8.4 [CAP/09]
 *   occurs:	1 (VCALSTORE)
 *   datatypes:	URI (1)
 *   default:	---
 *   allowed:	mailto URI???
 *   params:	xparam (0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2002/12/03 slh
 */
public
class  CalMaster
extends  URIProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a CALMASTER property, unset.
   */
  public
  CalMaster  (		)
  {
    super( Names.strProp_CalMaster );
    m_strScheme = mc_strScheme;
  }


  /**
   * Create a CALMASTER property set to supplied value.
   */
  public
  CalMaster  (String	strValue	)
  {
    super( Names.strProp_CalMaster , strValue );
    m_strScheme = mc_strScheme;
  }


/*----------------------------------------------------------------------------
 *						Class public Data
 *--------------------------------------------------------------------------*/

//???actually can be other contact uri
  static final public String	mc_strScheme	= "mailto";


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	args[]	)
  {
    CalMaster	calmaster	= new CalMaster(  );

    try {
      /*void*/System.out.println( calmaster );

      /*void*/calmaster.set( "mailto:slh@slh.net" );
      /*void*/System.out.println( calmaster );

      /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
      /*void*/calmaster.set( "http://slh.net:666/alocation" );
      /*void*/System.out.println( calmaster );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
  }

}


/* Log:
 *  0.00  2002/12/03  slh
 *        create from Decreed
 */
/*--CalMaster.java----------------------------------------------------------*/
