/*++CSID.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.URIProp;


/**
 * CAP CSID property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	8.6 [CAP/09]
 *   occurs:	1 (VCALSTORE)
 *   datatypes:	URI (1)
 *   default:	---
 *   allowed:	cap URI
 *   params:	xparam (0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2002/12/03 slh
 */
public
class  CSID
extends  URIProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a CSID property, unset.
   */
  public
  CSID  (		)
  {
    super( Names.strProp_CSID );
    m_strScheme = mc_strScheme;
  }


  /**
   * Create a CSID property set to supplied value.
   */
  public
  CSID  (String	strValue	)
  {
    super( Names.strProp_CSID , strValue );
    m_strScheme = mc_strScheme;
  }


/*----------------------------------------------------------------------------
 *						Class public Data
 *--------------------------------------------------------------------------*/

  static final public String	mc_strScheme	= "cap";


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	args[]	)
  {
    CSID	csid		= new CSID(  );

    try {
      /*void*/System.out.println( csid );

      /*void*/csid.set( "cap://slh.net:666/alocation" );
      /*void*/System.out.println( csid );

      /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
      /*void*/csid.set( "http://slh.net:666/alocation" );
      /*void*/System.out.println( csid );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
  }

}


/* Log:
 *  0.00  2002/12/03  slh
 *        create from Target
 */
/*--CSID.java---------------------------------------------------------------*/
