/*++CARLevel.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.util.HashMap;

import  edu.washington.cac.calendar.icalendar.EnumProp;


/**
 * CAP CAR-LEVEL property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	10.3 [CAP/09]
 *   occurs:	1 (VREPLY (GET-CAPABILTIES))
 *   datatypes:	TEXT (1)
 *   default:	"CAR-NONE"
 *   allowed:	"CAR-NONE", "CAR-MIN", "CAR-FULL-1"
 *   params:	xparam (0+)???
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/02/05 slh
 */
public
class  CARLevel
extends  EnumProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a CAR-LEVEL property, set to default.
   */
  public
  CARLevel  (		)
  {
    super( Names.strProp_CARLevel );
  }


  /**
   * Create a CAR-LEVEL property set to supplied value.
   */
  public
  CARLevel  (String	strValue	)
  {
    super( Names.strProp_CARLevel , strValue );
  }


  /**
   * Create a CAR-LEVEL property set to supplied value.
   */
  public
  CARLevel  (int	iValue	)
  {
    super( Names.strProp_CARLevel , iValue );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    m_hmValue.put( new Integer( CARNONE ) , Names.strValue_CARNone );
    m_hmValue.put( new Integer( CARMIN ) , Names.strValue_CARMin );
    m_hmValue.put( new Integer( CARFULL1 ) , Names.strValue_CARFull1 );

    m_strDefault = Names.strValue_CARNone;
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	CARNONE		=  1;
  final static public  int	CARMIN		=  2;
  final static public  int	CARFULL1	=  3;

}


/* Log:
 *  0.10  2003/02/05  slh
 *        (new year, new version...)
 *        configEnum(), etc
 *        redo constructors
 *  0.00  2002/10/28, 2002/10/29  slh
 *        create
 */
/*--CARLevel.java-----------------------------------------------------------*/
