/*++CARID.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.TextProp;


/**
 * CAP CARID property.
 *
 * <PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	8.5 [CAP/09]
 *   occurs:	1 (VCAR)
 *   datatypes:	TEXT
 *   default:	---
 *   allowed:	---
 *   params:	xparam (0+)
 * </PRE>
 *
 * @author  slh
 * @version  0.10 2003/01/13 slh
 */
public
class  CARID
extends  TextProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a CARID property, unset.
   */
  public
  CARID  (		)
  {
    super( Names.strProp_CARID );
  }


  /**
   * Create a CARID property set to supplied value.
   */
  public
  CARID  (String	strValue	)
  {
    super( Names.strProp_CARID , strValue );
  }

}


/* Log:
 *  0.10  2003/01/13  slh
 *        (new year, new version...)
 *        allow Property to take care of allowed params
 *  0.00  2002/11/12  slh
 *        create
 */
/*--CARID.java--------------------------------------------------------------*/
