/*++CAPVersion.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  edu.washington.cac.calendar.icalendar.TextListProp;


/**
 * CAP CAP-VERSION property.
 *
 * ``MUST include at least "1.0" for this version of CAP''.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	9.3
 *   occurs:	0 (VREPLY (GET-CAPABILTIES))
 *   datatypes:	TEXT (1-2)
 *   default:	---
 *   allowed:	;-separated
 *   params:	xparam (0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2002/11/06 slh
 */
public
class  CAPVersion
extends  TextListProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a CAP-VERSION property unset.
   */
  /* this is the base constructor */
  public
  CAPVersion  (		)
  {
    super( Names.strProp_CAPVersion ,
	   mc_strDelimiter , mc_MinElement , mc_MaxElement );
  }


  /**
   * Create a CAP-VERSION property set to supplied value.
   */
  public
  CAPVersion  (String	strValues	)
  {
    this(  );

    try {
      /*void*/set( strValues );
    } catch (Exception	e	) {
      throw new IllegalArgumentException( e.getLocalizedMessage(  ) );
    }
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  String	mc_strCurrentVersion	= "1.0";
  final static public  String	mc_strDelimiter		= ";";
  final static public  int	mc_MinElement		= 1;
  final static public  int	mc_MaxElement		= 2;

}


/* Log:
 *  0.00  2002/10/28, 2002/10/29, 2002/11/06  slh
 *        create
 */
/*--CAPVersion.java---------------------------------------------------------*/
