/*++AttCounter.java+++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.util.HashMap;

import  edu.washington.cac.calendar.icalendar.CalAddressProp;
import  edu.washington.cac.calendar.icalendar.XParam;		/* for main */


/**
 * CAP ATT-COUNTER property.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	8.2 [CAP/09]
 *   occurs:	0-1 (VCALENDAR)???
 *   datatypes:	CAL-ADDRESS (1)
 *   default:	---
 *   allowed:	---
 *   params:	xparam (0+)
 *</PRE>
 *
 * @author  slh
 * @version  0.00 2002/12/11 slh
 */
public
class  AttCounter
extends  CalAddressProp
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a ATT-COUNTER property, unset.
   */
  public
  AttCounter  (		)
  {
    super( Names.strProp_AttCounter );
  }


  /**
   * Create a ATT-COUNTER property set to supplied value.
   */
  public
  AttCounter  (String	strValue	)
  {
    super( Names.strProp_AttCounter );

    try {
      /*void*/set( strValue );
    } catch (Exception	e	) {
      throw new IllegalArgumentException( getName(  ) + ": " + e );
    }
  }


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    AttCounter	attcounter	= new AttCounter( "mailto:slh@slh.net" );
    XParam	xparam		= new XParam( "X-SLH-TEST" );

    /*void*/System.out.println( attcounter );

    try {
      /*void*/xparam.set( "me" );
      /*void*/attcounter.addParameter( xparam );
      /*void*/System.out.println( attcounter );

      /*void*/System.out.println(
		"NOTE: should throw MalformedURLException:" );
      /*void*/attcounter.set( "foo" );
      /*void*/System.out.println( attcounter );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
  }

}


/* Log:
 *  0.00  2002/12/11  slh
 *        create
 */
/*--AttCounter.java---------------------------------------------------------*/
