/*++ActionParam.java++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Log:
 * see eof
 */


package  edu.washington.cac.calendar.cap;


import  java.util.HashMap;

import  edu.washington.cac.calendar.icalendar.EnumParam;


/**
 * CAP ACTION parameter.
 *
 *<PRE>	<!-- for alignment purposes -->&nbsp;
 * Spec:
 *   section:	10.1 [CAP/09]
 *   occurs:	0-1 (CMD)
 *   datatypes:	TEXT (1)
 *   default:	---
 *   allowed:	"ASK", "ABORT"
 *</PRE>
 *
 * @author  slh
 * @version  0.10 2003/02/05 slh
 */
public
class  ActionParam
extends  EnumParam
{

/*----------------------------------------------------------------------------
 *						Constructors
 *--------------------------------------------------------------------------*/

  /**
   * Create a ACTION parameter, unset.
   */
  public
  ActionParam  (		)
  {
    super( Names.strParam_Action );
  }


  /**
   * Create a ACTION parameter set to supplied string value.
   */
  public
  ActionParam  (String	strValue	)
  {
    super( Names.strParam_Action , strValue );
  }


  /**
   * Create a ACTION parameter set to supplied id value.
   */
  public
  ActionParam  (int	iValue	)
  {
    super( Names.strParam_Action , iValue );
  }


/*----------------------------------------------------------------------------
 *						Object Protected Methods
 *--------------------------------------------------------------------------*/

  /*Note: overriding EnumProp.configEnum()
    which is called in EnumProp.EnumProp(*).
  */
  protected
  void
  configEnum  (		)
  {
    m_hmValue = new HashMap(  );
    m_hmValue.put( new Integer( ASK ) , Names.strValue_Ask );
    m_hmValue.put( new Integer( ABORT ) , Names.strValue_Abort );

    /* no default */
  }


/*----------------------------------------------------------------------------
 *						Class Public Constants
 *--------------------------------------------------------------------------*/

  final static public  int	ASK		=  1;
  final static public  int	ABORT		=  2;


/*----------------------------------------------------------------------------
 *						Main
 *--------------------------------------------------------------------------*/

  static public
  void  main  (String	argv[]	)
  {
    ActionParam		actionparam		= new ActionParam(  );

    /*void*/System.out.println( actionparam );

    try {
      /*void*/actionparam.set( "ask" );
      /*void*/System.out.println( actionparam );

      /*void*/actionparam.set( ActionParam.ABORT );
      /*void*/System.out.println( actionparam );
    } catch (Exception	e	) {
      /*void*/e.printStackTrace(  );
    }

    /*void*/System.out.println( actionparam.get(  ) );
    /*void*/System.out.println( actionparam.getEnum(  ) );

    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/actionparam.set( 666 );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println(
		"NOTE: should throw IllegalArgumentException:" );
    try {
      /*void*/actionparam.set( "six six six" );
    } catch (Exception	e	) {
      /*void*/System.out.println( "\t" + e );
    }
    /*void*/System.out.println( actionparam );
  }

}


/* Log:
 *  0.10  2003/02/05  slh
 *        (new year, new version...)
 *        configEnum(), etc
 *        redo constructors
 *  0.00  2002/10/23, 2002/10/29  slh
 *        create from ValueTypeParam.java
 */
/*--ActionParam.java--------------------------------------------------------*/
