--
--	psql -d postgres -e calendardb < schema.pgsql
--
CREATE TABLE events (
  eventid SERIAL PRIMARY KEY,	
  lastmod TIMESTAMP NOT NULL,		
  seq INTEGER NOT NULL,			
  publicf CHAR(1) NOT NULL,			
  created DATETIME NOT NULL,
  startdate DATE NOT NULL,		
  starttime TIME,
  enddate DATE NOT NULL,
  endtime TIME,
  shortdesc VARCHAR(255) NOT NULL,
  longdesc BYTEA,
  longdesc1 BYTEA,
  longdesc2 BYTEA,
  link VARCHAR(255),				
    /* T = tentative, F = confirmed, C = Cancelled, P = postponed */
  status CHAR(1) NOT NULL DEFAULT 'F',
  locationid INTEGER NOT NULL,				
  sponsorid INTEGER NOT NULL,			
  creator VARCHAR(20) NOT NULL,			
    /* N = no recurrence, M = master record for an expanded recurrence */
  recurring_status CHAR(1) NOT NULL DEFAULT 'N',

  cost VARCHAR(255),

  KEY (publicf),
  KEY (startdate),
  KEY (enddate),
  KEY (shortdesc(10)),
  KEY (status),
  KEY (locationid),
  KEY (sponsorid),
  KEY (creator)
);

# all instances of expanded recurrences
CREATE TABLE master_details (
  detailid SERIAL PRIMARY KEY, # id of an instance
  master_eventid INTEGER NOT NULL,                      # from events table
  startdate DATE NOT NULL,
  starttime TIME,
  enddate DATE NOT NULL,
  endtime TIME,

  KEY (master_eventid),
  KEY (startdate),
  KEY (enddate),
  KEY (startdate, enddate)
);

CREATE TABLE recurrence_dates (
  eventid INTEGER NOT NULL,		
  type CHAR(1) NOT NULL,			
  recurstartdate DATE NOT NULL,	
  recurstarttime TIME,		
  recurenddate DATE NOT NULL,  
  recurendtime TIME,	   

  KEY (eventid),
  KEY (recurstartdate),
  KEY (recurenddate)
);

CREATE TABLE recurrence_rules (
     -- key for recurrence rules tables
  ruleid SERIAL PRIMARY KEY,
  eventid INTEGER NOT NULL,			
  type CHAR(1) NOT NULL,			
  freq CHAR(1) NOT NULL, 
  multiplier INTEGER NOT NULL DEFAULT 1,  
    -- if count isn't null, untildate should be ignored
  count INTEGER,				
  untildate DATE NOT NULL,			
  untiltime TIME,				
  wkst CHAR(2) NOT NULL DEFAULT "SU",	

  KEY (untildate)
);

CREATE TABLE bywhat (
  ruleid INTEGER NOT NULL,		
    --S(econd), M(inute), H(our), (month)D(ay), Y(earday), W(eekno), (m)O(nth),
    --(d)A(y), (set)P(os)
  type CHAR(1) NOT NULL,
  number INTEGER NOT NULL, 
  KEY (ruleid)
);

CREATE TABLE event_keywords (	
  eventid INTEGER NOT NULL,
  keywordid INTEGER NOT NULL,		

  KEY (eventid),
  KEY (keywordid)
);

CREATE TABLE keywords (			
  keywordid SERIAL PRIMARY KEY,
  word VARCHAR(255)  NOT NULL,
  longdesc BYTEA,			
  longdesc1 BYTEA,
  creator VARCHAR(20)  NOT NULL,		
  publicf CHAR(1) NOT NULL DEFAULT 'T',			

  KEY (word(10)),
  KEY (creator),
  KEY (publicf)
);

CREATE TABLE locations (		
  locationid SERIAL PRIMARY KEY,
    /* on-campus: building + room
       off-campus:  name of place
       nowhere (e.g., radio program): name of station, URL, etc.
     */
  address VARCHAR(255)  NOT NULL DEFAULT '',
    /* on-campus: UW, plus any other necessary info
       off-campus: address, plus any other necessary info
     */
  subaddress VARCHAR(255) ,		
  link VARCHAR(255) ,				
  creator VARCHAR(20)  NOT NULL,			
  publicf CHAR(1) NOT NULL DEFAULT 'T',			

  KEY (address),
  KEY (creator),
  KEY (publicf)
);

CREATE TABLE sponsors (			
  sponsorid SERIAL PRIMARY KEY,
  name VARCHAR(255)  NOT NULL DEFAULT '',
  phone VARCHAR(255) ,
  email VARCHAR(255) ,
  link VARCHAR(255) ,				
  creator VARCHAR(20)  NOT NULL,			
  publicf CHAR(1) NOT NULL DEFAULT 'T',			

  KEY (name(10)),
  KEY (creator),
  KEY (publicf)
);

CREATE TABLE auth (
  userid INTEGER NOT NULL,
  usertype	varchar(1),
  lastname	varchar(255),
  firstname	varchar(255),
  phone		varchar(255),
  email		varchar(255),
  department	varchar(255)
);

CREATE TABLE users (     
  userid SERIAL PRIMARY KEY,
  username varchar(20) NOT NULL,
  created DATETIME,      
  last_logon DATETIME,   
  last_access DATETIME,  
  last_modify DATETIME,  

  KEY (username)
);

CREATE TABLE eventrefs (  
  eventid INTEGER NOT NULL,
  userid INTEGER NOT NULL,
  purpose CHAR(1) NOT NULL DEFAULT 'E'

  KEY (eventid),
  KEY (userid)
);

CREATE TABLE calendars (
  calendarid SERIAL PRIMARY KEY, 
  name VARCHAR(200), 
  type CHAR(1) NOT NULL,
  ref_num  INTEGER NOT NULL,
  parent INTEGER NOT NULL DEFAULT 0
);

CREATE TABLE subscriptions (    -- references to calendars for a user
  userid INTEGER NOT NULL,
  calendarid INTEGER NOT NULL,

  KEY (userid),
  KEY (calendarid)
);

-- useful location and sponsor values
insert into locations (locationid, address, creator, publicf) values (1, 'none', '007', 'T');
insert into locations (locationid, address, creator, publicf) values (2, 'unknown', '007', 'T');
insert into sponsors (sponsorid, name, creator, publicf) values (1, 'none', '007', 'T');
insert into sponsors (sponsorid, name, creator, publicf) values (2, 'unknown', '007', 'T');
insert into locations (locationid, address, subaddress, creator, publicf) values (3, 'deleted', 'Used as a replacement when the owner of a public location used by others deletes the location', '007', 'T');
insert into sponsors (sponsorid, name, phone, creator, public) values (3, 'deleted', 'Used as a replacement when the owner of a public sponsor used by others deletes the sponsor', '007', 'T');

-- default keywords for official public events
insert into keywords (keywordid, word, creator, publicf) values (35, 'Academic Calendar', '007other', 'T');
insert into keywords (keywordid, word, creator, publicf) values (34, 'Holidays', '007other', 'T');
insert into keywords (keywordid, word, creator, publicf) values (33, 'Alerts', '007other', 'T');
insert into keywords (keywordid, word, creator, publicf) values (1, 'Benefits', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (2, 'Commencement', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (3, 'Concerts', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (24, 'Conferences', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (4, 'Dance', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (22, 'Deadlines', '007unofficial', 'T');
insert into keywords (keywordid, word, creator, publicf) values (5, 'Drama', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (6, 'Exhibits', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (7, 'Films', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (25, 'Forums', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (8, 'Health Sciences', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (9, 'Hearings', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (10, 'Lectures', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (29, 'Meetings', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (11, 'Open Houses', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (12, 'Operas', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (13, 'Radio', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (14, 'Readings', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (15, 'Sales', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (16, 'Seminars', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (17, 'Special Events', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (18, 'Sports', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (19, 'Television', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (20, 'Tours', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (21, 'Training', '007main', 'T');
insert into keywords (keywordid, word, creator, publicf) values (26, 'Workshops', '007main', 'T');

-- sponsors for the 'all calendars' page
insert into sponsors (sponsorid, name, creator, publicf) values (1667, 'Benefits Office', '007', 'T');
insert into sponsors (sponsorid, name, creator, publicf) values (1673, 'Recruiting & Candidate Services', '007', 'T');
insert into sponsors (sponsorid, name, creator, publicf) values (1672, 'Training & Development', '007', 'T');
insert into sponsors (sponsorid, name, creator, publicf) values (1668, 'Work/Life Office', '007', 'T');

--bootstrap users for pubevents auth table and class meetings
insert into users (userid, username) values (2, '007-ts');
insert into users (userid, username) values (3, '1user');
insert into users (userid, username) values (4, 'caladmin');
insert into users (userid, username) values (5, 'calcontent');
insert into users (userid, username) values (6, 'calowner');
insert into users (userid, username) values (7, 'calowner2');
insert into users (userid, username) values (8, 'calowner3');

insert into auth (userid, usertype, lastname)
    values (3, 'A', 'dummy user to get things started');
insert into auth (userid, usertype, lastname)
    values (4, 'A', 'dummy admin user');
insert into auth (userid, usertype, lastname)
    values (5, 'C', 'dummy calendar content admin user');
insert into auth (userid, usertype, lastname)
    values (6, 'P', 'dummy public events owner user');
insert into auth (userid, usertype, lastname)
    values (7, 'P', 'dummy public events owner user');
insert into auth (userid, usertype, lastname)
    values (8, 'P', 'dummy public events owner user');

-- keyword_attrs - store attributes of keywords
--     for example, flag alert categories
--  kaid          unique key
--  kakeywordid:  id of keyword entry
--  kaname:       attribute name
--  kaval:        attribute value

CREATE TABLE keyword_attrs (
  kaid INTEGER NOT NULL IDENTITY,
  kakeywordid INTEGER NOT NULL,
  kaname VARCHAR(255) NOT NULL,
  kaval VARCHAR(255) NOT NULL
);

CREATE INDEX kwaid on keyword_attrs(kakeywordid);
CREATE INDEX kwanm on keyword_attrs(kaname);
CREATE INDEX kwavl on keyword_attrs(kaval);

-- table to store lastmod timestamp - indexed and searched by name
CREATE TABLE lastmods (
  name VARCHAR(255) NOT NULL,	-- key
  lastmod TIMESTAMP NOT NULL
);

CREATE INDEX lmnm on lastmods(name);

insert into lastmods values ('pubevents', '2003-07-03 13:12:29.0');

CREATE TABLE adminGroups (
  groupname VARCHAR(255) NOT NULL,
  description LONGVARCHAR,
  groupOwner VARCHAR(20) NOT NULL,
  ownerid VARCHAR(20) NOT NULL
);

CREATE INDEX agnm on adminGroups(groupname);
CREATE INDEX aggo on adminGroups(groupOwner);
CREATE INDEX agoi on adminGroups(ownerid);

insert into adminGroups values ('grp1', 'Demo group with 2 members',
                                'caladmin', 'agrp_grp1');
insert into adminGroups values ('grp2', 'Demo group with 2 members',
                                'calowner3', 'agrp_grp2');

CREATE TABLE adminGroupMembers (
  groupname VARCHAR(255),
  userid VARCHAR(20) NOT NULL
);

CREATE INDEX agmnm on adminGroupMembers(groupname);
CREATE INDEX agmui on adminGroupMembers(userid);

insert into adminGroupMembers values ('grp1', 'caladmin');
insert into adminGroupMembers values ('grp1', 'calowner');
insert into adminGroupMembers values ('grp2', 'calowner2');
insert into adminGroupMembers values ('grp2', 'calowner3');

-- Preferences for authorized users
CREATE TABLE authprefs (
  userid INTEGER NOT NULL,
  autoaddKeywords CHAR(1) NOT NULL,  -- DEFAULT 'T',
  autoaddLocations CHAR(1) NOT NULL, -- DEFAULT 'T',
  autoaddSponsors CHAR(1) NOT NULL   -- DEFAULT 'T'
);

CREATE INDEX apui on authprefs(userid);

-- Preferred keywords for authorized users
CREATE TABLE authprefKeywords (
  userid INTEGER NOT NULL,
  keywordid INTEGER NOT NULL
);

CREATE INDEX apkui on authprefKeywords(userid);

-- Preferred locations for authorized users
CREATE TABLE authprefLocations (
  userid INTEGER NOT NULL,
  locationid INTEGER NOT NULL
);

CREATE INDEX aplui on authprefLocations(userid);

-- Preferred sponsors for authorized users
CREATE TABLE authprefSponsors (
  userid INTEGER NOT NULL,
  sponsorid INTEGER NOT NULL
);

CREATE INDEX apsui on authprefSponsors(userid);

insert into auth (userid, usertype, lastname) values (3, 'A', 'dummy user to get things started');
