--
-- @author Greg Barnes, Cameron Mallory, modified for DB2 by Drake Emko
--
--	To load use:
--
--	db2 -tvf schema.db2
--
--  db.properties: hasDefaults=true, hasNow=false
--
--  Note: someone needs to add indices to this schema before it gets
--  used in production.  I don't know the DB2 syntax is for indices, though.
--          (Greg Barnes)

DROP TABLE events;
DROP TABLE recurrence_dates;
DROP TABLE recurrence_rules;
DROP TABLE bywhat;
DROP TABLE event_keywords;
DROP TABLE keywords;
DROP TABLE locations;
DROP TABLE sponsors;
DROP TABLE users;
DROP TABLE eventrefs;
DROP TABLE auth;
DROP TABLE master_details;
DROP TABLE calendars;
DROP TABLE subscriptions;
DROP TABLE keyword_attrs;
DROP TABLE lastmods;
DROP TABLE adminGroups;
DROP TABLE adminGroupMembers;
DROP TABLE authprefs;
DROP TABLE authprefKeywords;
DROP TABLE authprefLocations;
DROP TABLE authprefSponsors;

CREATE TABLE events (
  eventid INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) PRIMARY KEY,
  lastmod TIMESTAMP NOT NULL with DEFAULT CURRENT TIMESTAMP,
  seq INTEGER NOT NULL,
  publicf CHAR(1) NOT NULL,
  created TIMESTAMP NOT NULL with DEFAULT CURRENT TIMESTAMP,
  startdate DATE NOT NULL,		
  starttime TIME,
  enddate DATE NOT NULL,
  endtime TIME,
  shortdesc VARCHAR(255) NOT NULL,
  longdesc varchar(255),
  longdesc1 varchar(255),
  longdesc2 varchar(255),
  link VARCHAR(255),
  status CHAR(1) NOT NULL with DEFAULT 'F',
  locationid INTEGER NOT NULL,
  sponsorid INTEGER NOT NULL,
  creator VARCHAR(20) NOT NULL,

    -- N = no recurrence, M = master record for an expanded recurrence
  recurring_status CHAR(1) NOT NULL with DEFAULT 'N',

    --not in iCal
  cost VARCHAR(255)
);

CREATE TABLE recurrence_dates (
  eventid INTEGER NOT NULL,
  type CHAR(1) NOT NULL,
  recurstartdate DATE NOT NULL,	
  recurstarttime TIME,	
  recurenddate DATE NOT NULL,
  recurendtime TIME
);

CREATE TABLE recurrence_rules (
  ruleid INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) PRIMARY KEY,
  eventid INTEGER NOT NULL,
  type CHAR(1) NOT NULL,
  freq CHAR(1) NOT NULL, 
  multiplier INTEGER NOT NULL with DEFAULT 1,
  count INTEGER,
  untildate DATE NOT NULL,
  untiltime TIME,
  wkst CHAR(2) NOT NULL with DEFAULT 'SU'
);

-- ruleid:
-- S(econd), M(inute), H(our), (month)D(ay), Y(earday), W(eekno), (m)O(nth),
-- (d)A(y), (set)P(os)
CREATE TABLE bywhat (
  ruleid INTEGER NOT NULL,
  type CHAR(1) NOT NULL,
  number INTEGER NOT NULL
);

-- all instances of expanded recurrences
CREATE TABLE master_details (
  detailid INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) PRIMARY KEY,	
  master_eventid INTEGER NOT NULL,		        -- from events table
  startdate DATE NOT NULL,		
  starttime TIME,
  enddate DATE NOT NULL,
  endtime TIME
);

CREATE TABLE event_keywords (
  eventid INTEGER NOT NULL,
  keywordid INTEGER NOT NULL
);

CREATE TABLE keywords (
  keywordid INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) PRIMARY KEY,
  word VARCHAR(255) NOT NULL,
  longdesc varchar(255),
  longdesc1 varchar(255),
  creator VARCHAR(20) NOT NULL,
  publicf CHAR(1) NOT NULL with DEFAULT 'T'
);

CREATE TABLE locations (
  locationid INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) PRIMARY KEY,
  address VARCHAR(255) NOT NULL with DEFAULT '',
  subaddress VARCHAR(255),
  link VARCHAR(255),
  creator VARCHAR(20) NOT NULL,
  publicf CHAR(1) NOT NULL with DEFAULT 'T'
);

CREATE TABLE sponsors (
  sponsorid INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) PRIMARY KEY,
  name VARCHAR(255) NOT NULL with DEFAULT '',
  phone VARCHAR(255),
  email VARCHAR(255),
  link VARCHAR(255),
  creator VARCHAR(20) NOT NULL,
  publicf CHAR(1) NOT NULL with DEFAULT 'T'
);

CREATE TABLE auth (
  userid INTEGER NOT NULL,
  usertype	varchar(1),
  lastname	varchar(255),
  firstname	varchar(255),
  phone		varchar(255),
  email		varchar(255),
  department	varchar(255)
);

CREATE TABLE users (
  userid INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) PRIMARY KEY,
  username varchar(20) NOT NULL,
  created TIMESTAMP,
  last_logon TIMESTAMP,
  last_access TIMESTAMP,
  last_modify TIMESTAMP
);

CREATE TABLE eventrefs (
  eventid INTEGER NOT NULL,
  userid INTEGER NOT NULL,
    -- 'E' = explicitly added by users.  Other values to indicate refs added 
    -- some other way
  purpose CHAR(1) NOT NULL with DEFAULT 'E'
);

CREATE TABLE calendars (
  calendarid INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) PRIMARY KEY,
  name VARCHAR(200), 
  type CHAR(1) NOT NULL,
  ref_num  INTEGER NOT NULL,
  parent INTEGER NOT NULL with DEFAULT 0
);

CREATE TABLE subscriptions (    -- references to calendars for a user
  userid INTEGER NOT NULL,
  calendarid INTEGER NOT NULL
);

--useful values for location and sponsors
insert into locations (address, creator) values ('none', '007'), ('unknown', '007');
insert into sponsors (name, creator) values ('none', '007'), ('unknown', '007');
insert into locations (address, subaddress, creator) values ('deleted', 'Used as a replacement when the owner of a public location used by others deletes the location', '007');
insert into sponsors (name, phone, creator) values ('deleted', 'Used as a replacement when the owner of a public sponsor used by others deletes the sponsor', '007');
--default keywords for official public events
insert into keywords (keywordid, word, creator, publicf) values 
  (35, 'Academic Calendar', '007other', 'T'),
  (34, 'Holidays', '007other', 'T'),
  (33, 'Alerts', '007other', 'T'),
  (1, 'Benefits', '007main', 'T'),
  (2, 'Commencement', '007main', 'T'),
  (3, 'Concerts', '007main', 'T'),
  (24, 'Conferences', '007main', 'T'),
  (4, 'Dance', '007main', 'T'),
  (22, 'Deadlines', '007unofficial', 'T'),
  (5, 'Drama', '007main', 'T'),
  (6, 'Exhibits', '007main', 'T'),
  (7, 'Films', '007main', 'T'),
  (25, 'Forums', '007main', 'T'),
  (8, 'Health Sciences', '007main', 'T'),
  (9, 'Hearings', '007main', 'T'),
  (10, 'Lectures', '007main', 'T'),
  (29, 'Meetings', '007main', 'T'),
  (11, 'Open Houses', '007main', 'T'),
  (12, 'Operas', '007main', 'T'),
  (13, 'Radio', '007main', 'T'),
  (14, 'Readings', '007main', 'T'),
  (15, 'Sales', '007main', 'T'),
  (16, 'Seminars', '007main', 'T'),
  (17, 'Special Events', '007main', 'T'),
  (18, 'Sports', '007main', 'T'),
  (19, 'Television', '007main', 'T'),
  (20, 'Tours', '007main', 'T'),
  (21, 'Training', '007main', 'T'),
  (26, 'Workshops', '007main', 'T');

-- sponsors for the 'all calendars' page
insert into sponsors (sponsorid, name, creator, publicf) values 
  (1667, 'Benefits Office', '007', 'T'),
  (1673, 'Recruiting & Candidate Services', '007', 'T'),
  (1672, 'Training & Development', '007', 'T'),
  (1668, 'Work/Life Office', '007', 'T');

--bootstrap users for pubevents auth table and class meetings
insert into users (userid, username) values (2, '007-ts');
insert into users (userid, username) values (3, '1user');
insert into users (userid, username) values (4, 'caladmin');
insert into users (userid, username) values (5, 'calcontent');
insert into users (userid, username) values (6, 'calowner');
insert into users (userid, username) values (7, 'calowner2');
insert into users (userid, username) values (8, 'calowner3');

insert into auth (userid, usertype, lastname)
    values (3, 'A', 'dummy user to get things started');
insert into auth (userid, usertype, lastname)
    values (4, 'A', 'dummy admin user');
insert into auth (userid, usertype, lastname)
    values (5, 'C', 'dummy calendar content admin user');
insert into auth (userid, usertype, lastname)
    values (6, 'P', 'dummy public events owner user');
insert into auth (userid, usertype, lastname)
    values (7, 'P', 'dummy public events owner user');
insert into auth (userid, usertype, lastname)
    values (8, 'P', 'dummy public events owner user');

-- keyword_attrs - store attributes of keywords
--     for example, flag alert categories
--  kaid          unique key
--  kakeywordid:  id of keyword entry
--  kaname:       attribute name
--  kaval:        attribute value

CREATE TABLE keyword_attrs (
  kaid INTEGER NOT NULL IDENTITY,
  kakeywordid INTEGER NOT NULL,
  kaname VARCHAR(255) NOT NULL,
  kaval VARCHAR(255) NOT NULL
);

CREATE INDEX kwaid on keyword_attrs(kakeywordid);
CREATE INDEX kwanm on keyword_attrs(kaname);
CREATE INDEX kwavl on keyword_attrs(kaval);

-- table to store lastmod timestamp - indexed and searched by name
CREATE TABLE lastmods (
  name VARCHAR(255) NOT NULL,	-- key
  lastmod TIMESTAMP NOT NULL
);

CREATE INDEX lmnm on lastmods(name);

insert into lastmods values ('pubevents', '2003-07-03 13:12:29.0');

CREATE TABLE adminGroups (
  groupname VARCHAR(255) NOT NULL,
  description LONGVARCHAR,
  groupOwner VARCHAR(20) NOT NULL,
  ownerid VARCHAR(20) NOT NULL
);

CREATE INDEX agnm on adminGroups(groupname);
CREATE INDEX aggo on adminGroups(groupOwner);
CREATE INDEX agoi on adminGroups(ownerid);

insert into adminGroups values ('grp1', 'Demo group with 2 members',
                                'caladmin', 'agrp_grp1');
insert into adminGroups values ('grp2', 'Demo group with 2 members',
                                'calowner3', 'agrp_grp2');

CREATE TABLE adminGroupMembers (
  groupname VARCHAR(255),
  userid VARCHAR(20) NOT NULL
);

CREATE INDEX agmnm on adminGroupMembers(groupname);
CREATE INDEX agmui on adminGroupMembers(userid);

insert into adminGroupMembers values ('grp1', 'caladmin');
insert into adminGroupMembers values ('grp1', 'calowner');
insert into adminGroupMembers values ('grp2', 'calowner2');
insert into adminGroupMembers values ('grp2', 'calowner3');

-- Preferences for authorized users
CREATE TABLE authprefs (
  userid INTEGER NOT NULL,
  autoaddKeywords CHAR(1) NOT NULL,  -- DEFAULT 'T',
  autoaddLocations CHAR(1) NOT NULL, -- DEFAULT 'T',
  autoaddSponsors CHAR(1) NOT NULL   -- DEFAULT 'T'
);

CREATE INDEX apui on authprefs(userid);

-- Preferred keywords for authorized users
CREATE TABLE authprefKeywords (
  userid INTEGER NOT NULL,
  keywordid INTEGER NOT NULL
);

CREATE INDEX apkui on authprefKeywords(userid);

-- Preferred locations for authorized users
CREATE TABLE authprefLocations (
  userid INTEGER NOT NULL,
  locationid INTEGER NOT NULL
);

CREATE INDEX aplui on authprefLocations(userid);

-- Preferred sponsors for authorized users
CREATE TABLE authprefSponsors (
  userid INTEGER NOT NULL,
  sponsorid INTEGER NOT NULL
);

CREATE INDEX apsui on authprefSponsors(userid);

insert into auth (userid, usertype, lastname) values (3, 'A', 'dummy user to get things started');
