/*
 University of Washington License for UW Calendar

 Copyright (c) 2000-2003 University of Washington.  All rights reserved.

 Redistribution and use of this distribution in source and binary forms,
 with or without modification, are permitted provided that:

   The above copyright notice and this permission notice appear in
   all copies and supporting documentation;

   The name, identifiers, and trademarks of the University of Washington
   are not used in advertising or publicity without the express prior
   written permission of the University of Washington;

   Recipients acknowledge that this distribution is made available as a
   research courtesy, "as is", potentially with defects, without
   any obligation on the part of the University of Washington to
   provide support, services, or repair;

   THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR
   IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION
   ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
   PARTICULAR PURPOSE, AND IN NO EVENT SHALL THE UNIVERSITY OF
   WASHINGTON BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
   DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
   PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT (INCLUDING
   NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
   THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/*
  An outline for possible future expansion of the db schema to handle
  all of iCalendar, CAP, and all requirements.  This file should be used
  for reference purposes only.

  @author Clay Gravelle
 */

CREATE TABLE bytype_enum (
	bytypeid char (1)   NOT NULL ,
	bytypedesc varchar (10)   NOT NULL ,
	bynbrdesc varchar (10)   NULL 
) 

CREATE TABLE bywhat (
	ruleid int NOT NULL ,
	type char (1)   NOT NULL ,
	number int NOT NULL 
) 

CREATE TABLE carperm_enum (
	carpermid char (1)   NOT NULL ,
	carpermdesc varchar (10)   NOT NULL 
) 

CREATE TABLE dbsetup (
	versionnbr float NOT NULL ,
	last_modify datetime NOT NULL ,
	organization varchar (255)   NULL ,
	maxdate datetime NULL ,
	mindate datetime NULL ,
	reclimit int NULL ,
	mblimit int NULL ,
	recurlimit int NULL ,
	tzid varchar (20)   NOT NULL ,
	dblanguage varchar (20)   NOT NULL ,
	calendartype varchar (20)   NOT NULL ,
	orientation varchar (20)   NULL 
) 

CREATE TABLE event_keywords (
	eventid int NOT NULL ,
	keywordid int NOT NULL 
) 

CREATE TABLE eventrefs (
	eventid int NOT NULL ,
	userid int NOT NULL 
) 

CREATE TABLE evlong_enum (
	evlongid char (1)   NOT NULL ,
	evlongdesc varchar (10)   NOT NULL 
) 

CREATE TABLE evrefstransp_enum (
	transpid char (1)   NOT NULL ,
	transpdesc varchar (20)   NOT NULL 
) 

CREATE TABLE evstatus_enum (
	evstatusid char (1)   NOT NULL ,
	evstatusdesc varchar (10)   NOT NULL ,
	evstatusdef bit NOT NULL 
) 

CREATE TABLE evtype_enum (
	evtypeid char (1)   NOT NULL ,
	evtypedesc varchar (5)   NOT NULL ,
	evtypedef bit NOT NULL 
) 

CREATE TABLE fbtype_enum (
	fbtype char (1)   NOT NULL ,
	fbdesc varchar (10)   NOT NULL 
) 

CREATE TABLE invrole_enum (
	invroleid char (1)   NOT NULL ,
	invroledesc varchar (15)   NOT NULL ,
	invroledef bit NOT NULL 
) 

CREATE TABLE keywords (
	keywordid int IDENTITY (1, 1) NOT NULL ,
	word varchar (255)   NOT NULL ,
	longdesc text   NULL ,
	longdesc1 text   NULL ,
	creator varchar (20)   NOT NULL ,
	publicf char (1)   NOT NULL 
) 

CREATE TABLE locations (
	locationid int IDENTITY (1, 1) NOT NULL ,
	address varchar (255)   NOT NULL ,
	subaddress varchar (255)   NULL ,
	link varchar (255)   NULL ,
	creator varchar (20)   NOT NULL ,
	publicf char (1)   NOT NULL 
) 

CREATE TABLE preferences (
	prefid int IDENTITY (1, 1) NOT NULL ,
	prefdesc varchar (255)   NOT NULL ,
	prefgroup varchar (20)   NULL 
) 

CREATE TABLE recurfreq_enum (
	recurfreqid char (1)   NOT NULL ,
	recurfreqdesc varchar (10)   NOT NULL 
) 

CREATE TABLE recurrence_rules (
	ruleid int IDENTITY (1, 1) NOT NULL ,
	eventid int NOT NULL ,
	type char (1)   NOT NULL ,
	freq char (1)   NOT NULL ,
	multiplier int NOT NULL ,
	recurcount int NULL ,
	untildate datetime NOT NULL ,
	untiltime datetime NULL ,
	wkst char (2)   NOT NULL 
) 

CREATE TABLE recurwkst_enum (
	recurwkstid char (2)   NOT NULL ,
	recurwkstdesc varchar (10)   NOT NULL 
) 

CREATE TABLE sponsors (
	sponsorid int IDENTITY (1, 1) NOT NULL ,
	sponsorname varchar (255)   NOT NULL ,
	phone varchar (255)   NULL ,
	email varchar (255)   NULL ,
	link varchar (255)   NULL ,
	creator varchar (20)   NOT NULL ,
	publicf char (1)   NOT NULL 
) 

CREATE TABLE timezone (
	tzid varchar (50)   NOT NULL ,
	tzurl varchar (255)   NULL ,
	x_lic_location varchar (255)   NOT NULL ,
	standard bit NOT NULL ,
	tzoffsetfrom datetime NOT NULL ,
	tzoffsetto datetime NOT NULL ,
	tzname char (3)   NOT NULL ,
	ruleid int NULL 
) 

CREATE TABLE usertype_enum (
	usertypeid char (1)   NOT NULL ,
	usertypedesc char (10)   NOT NULL ,
	usertypedef bit NOT NULL 
) 

CREATE TABLE events2 (
	eventid int IDENTITY (1, 1) NOT NULL ,
	lastmod timestamp NOT NULL ,
	seq int NOT NULL ,
	publicf char (1)   NOT NULL ,
	created datetime NOT NULL ,
	startdate datetime NOT NULL ,
	starttime datetime NULL ,
	enddate datetime NOT NULL ,
	endtime datetime NULL ,
	shortdesc varchar (255)   NOT NULL ,
	longdesc text   NULL ,
	longdesc1 text   NULL ,
	longdesc2 text   NULL ,
	link varchar (255)   NULL ,
	status char (1)   NOT NULL ,
	locationid int NOT NULL ,
	sponsorid int NOT NULL ,
	creator varchar (20)   NOT NULL ,
	cost varchar (255)   NULL ,
	shortdescesh AS (left(shortdesc,10)) 
) 

CREATE TABLE auth (
	username varchar (20)   NOT NULL ,
	usertype varchar (50)   NULL ,
	lastname varchar (255)   NULL ,
	firstname varchar (255)   NULL ,
	phone varchar (255)   NULL ,
	email varchar (255)   NULL ,
	department varchar (255)   NULL ,
	tzname char (3)   NULL 
) 

CREATE TABLE events (
	eventid int IDENTITY (1, 1) NOT NULL ,
	lastmod timestamp NOT NULL ,
	seq int NOT NULL ,
	created datetime NOT NULL ,
	startdate datetime NOT NULL ,
	starttime datetime NULL ,
	enddate datetime NOT NULL ,
	endtime datetime NULL ,
	shortdesc varchar (255)   NOT NULL ,
	longdesc text   NULL ,
	longdesc1 text   NULL ,
	longdesc2 text   NULL ,
	link varchar (255)   NULL ,
	status char (1)   NOT NULL ,
	locationid int NOT NULL ,
	sponsorid int NOT NULL ,
	creator varchar (20)   NOT NULL ,
	cost varchar (255)   NULL ,
	longvalue char (1)   NULL ,
	eventtype char (1)   NOT NULL ,
	priority int NULL ,
	percentcomplete int NULL ,
	geo varchar (25)   NULL ,
	tzname char (3)   NULL 
) 

CREATE TABLE groups (
	groupid int NOT NULL ,
	groupdesc varchar (255)   NOT NULL ,
	parentgroupid int NULL ,
	creator varchar (20)   NOT NULL ,
	grouptype char (1)   NOT NULL ,
	created datetime NOT NULL 
) 

CREATE TABLE attachments (
	eventid int NOT NULL ,
	attachid int NOT NULL ,
	fieldname varchar (50)   NOT NULL ,
	fieldvalue image NOT NULL 
) 

CREATE TABLE extension (
	eventid int NOT NULL ,
	extid int NOT NULL ,
	fieldname varchar (255)   NOT NULL ,
	fieldvalue text   NOT NULL 
) 

CREATE TABLE groupeventrefs (
	groupid int NOT NULL ,
	eventid int NOT NULL 
) 

CREATE TABLE recurrence_dates (
	eventid int NOT NULL ,
	type char (1)   NOT NULL ,
	recurstartdate datetime NOT NULL ,
	recurstarttime datetime NULL ,
	recurenddate datetime NOT NULL ,
	recurendtime datetime NULL 
) 

CREATE TABLE alarms (
	eventid int NULL ,
	userid int NULL ,
	alarmtrigger datetime NOT NULL ,
	repeat int NULL ,
	duration datetime NOT NULL ,
	alarmaction char (1)   NOT NULL ,
	actdesc varchar (255)   NOT NULL 
) 

CREATE TABLE cars (
	userid int NOT NULL ,
	designatee int NULL ,
	groupid int NULL ,
	permission char (1)   NOT NULL ,
	rights bit NOT NULL ,
	calsubscribe bit NOT NULL 
) 

CREATE TABLE fbeventrefs (
	fbid int NOT NULL ,
	eventid int NOT NULL 
) 

CREATE TABLE freebusy (
	fbid int IDENTITY (1, 1) NOT NULL ,
	userid int NULL ,
	groupid int NULL ,
	startdate datetime NOT NULL ,
	starttime datetime NOT NULL ,
	enddate datetime NOT NULL ,
	endtime datetime NOT NULL ,
	fbtype char (1)   NOT NULL 
) 

CREATE TABLE groupuserref (
	groupid int NOT NULL ,
	userid int NOT NULL 
) 

CREATE TABLE invited (
	invitedid int NOT NULL ,
	eventid int NOT NULL ,
	partstat char (1)   NOT NULL ,
	role char (1)   NOT NULL ,
	last_modify datetime NOT NULL ,
	rsvp bit NOT NULL ,
	creator varchar (20)   NOT NULL 
) 

CREATE TABLE subscribegroup (
	userid int NOT NULL ,
	groupid int NOT NULL 
) 

CREATE TABLE subscribeuser (
	userid int NOT NULL ,
	subuser int NOT NULL 
) 

CREATE TABLE userpref (
	userid int NOT NULL ,
	prefid int NOT NULL ,
	userprefdata varchar (255)   NOT NULL 
) 

CREATE TABLE users (
	userid int IDENTITY (1, 1) NOT NULL ,
	username varchar (20)   NOT NULL ,
	usertype char (1)   NOT NULL ,
	created datetime NOT NULL ,
	last_logon datetime NULL ,
	last_access datetime NULL ,
	last_modify datetime NULL ,
	reclimit int NULL ,
	mblimit int NULL ,
	nbrevents int NOT NULL ,
	nbrmb int NOT NULL 
) 

ALTER TABLE bytype_enum WITH NOCHECK ADD 
	CONSTRAINT PK_bytype_enum PRIMARY KEY  CLUSTERED 
	(
		bytypeid
	)  

ALTER TABLE carperm_enum WITH NOCHECK ADD 
	CONSTRAINT PK_carperm_enum PRIMARY KEY  CLUSTERED 
	(
		carpermid
	)  

ALTER TABLE evlong_enum WITH NOCHECK ADD 
	CONSTRAINT PK_evlong_enum PRIMARY KEY  CLUSTERED 
	(
		evlongid
	)  

ALTER TABLE evrefstransp_enum WITH NOCHECK ADD 
	CONSTRAINT PK_evrefstransp_enum PRIMARY KEY  CLUSTERED 
	(
		transpid
	)  

ALTER TABLE evstatus_enum WITH NOCHECK ADD 
	CONSTRAINT PK_evstatus_enum PRIMARY KEY  CLUSTERED 
	(
		evstatusid
	)  

ALTER TABLE evtype_enum WITH NOCHECK ADD 
	CONSTRAINT PK_evtype_enum PRIMARY KEY  CLUSTERED 
	(
		evtypeid
	)  

ALTER TABLE fbtype_enum WITH NOCHECK ADD 
	CONSTRAINT PK_fbtype_enum PRIMARY KEY  CLUSTERED 
	(
		fbtype
	)  

ALTER TABLE invrole_enum WITH NOCHECK ADD 
	CONSTRAINT PK_invrole_enum PRIMARY KEY  CLUSTERED 
	(
		invroleid
	)  

ALTER TABLE keywords WITH NOCHECK ADD 
	 PRIMARY KEY  CLUSTERED 
	(
		keywordid
	)  

ALTER TABLE locations WITH NOCHECK ADD 
	 PRIMARY KEY  CLUSTERED 
	(
		locationid
	)  

ALTER TABLE preferences WITH NOCHECK ADD 
	CONSTRAINT PK_preferences PRIMARY KEY  CLUSTERED 
	(
		prefid
	)  

ALTER TABLE recurfreq_enum WITH NOCHECK ADD 
	CONSTRAINT PK_recurfreq_enum PRIMARY KEY  CLUSTERED 
	(
		recurfreqid
	)  

ALTER TABLE recurrence_rules WITH NOCHECK ADD 
	 PRIMARY KEY  CLUSTERED 
	(
		ruleid
	)  

ALTER TABLE recurwkst_enum WITH NOCHECK ADD 
	CONSTRAINT PK_recurwkst_enum PRIMARY KEY  CLUSTERED 
	(
		recurwkstid
	)  

ALTER TABLE sponsors WITH NOCHECK ADD 
	 PRIMARY KEY  CLUSTERED 
	(
		sponsorid
	)  

ALTER TABLE timezone WITH NOCHECK ADD 
	CONSTRAINT PK_timezone PRIMARY KEY  CLUSTERED 
	(
		tzid
	)  

ALTER TABLE usertype_enum WITH NOCHECK ADD 
	CONSTRAINT PK_usertype_enum PRIMARY KEY  CLUSTERED 
	(
		usertypeid
	)  

ALTER TABLE events2 WITH NOCHECK ADD 
	 PRIMARY KEY  CLUSTERED 
	(
		eventid
	)  

ALTER TABLE auth WITH NOCHECK ADD 
	CONSTRAINT PK_authorization PRIMARY KEY  CLUSTERED 
	(
		username
	)  

ALTER TABLE events WITH NOCHECK ADD 
	CONSTRAINT PK__events__60083D91 PRIMARY KEY  CLUSTERED 
	(
		eventid
	)  

ALTER TABLE groups WITH NOCHECK ADD 
	CONSTRAINT PK_groups PRIMARY KEY  CLUSTERED 
	(
		groupid
	)  

ALTER TABLE attachments WITH NOCHECK ADD 
	CONSTRAINT PK_attachments PRIMARY KEY  CLUSTERED 
	(
		eventid,
		attachid
	)  

ALTER TABLE extension WITH NOCHECK ADD 
	CONSTRAINT PK_Extension PRIMARY KEY  CLUSTERED 
	(
		eventid,
		extid
	)  

ALTER TABLE groupeventrefs WITH NOCHECK ADD 
	CONSTRAINT PK_groupeventrefs PRIMARY KEY  CLUSTERED 
	(
		groupid,
		eventid
	)  

ALTER TABLE recurrence_dates WITH NOCHECK ADD 
	 PRIMARY KEY  CLUSTERED 
	(
		eventid
	)  

ALTER TABLE cars WITH NOCHECK ADD 
	CONSTRAINT PK_cars PRIMARY KEY  CLUSTERED 
	(
		userid
	)  

ALTER TABLE fbeventrefs WITH NOCHECK ADD 
	CONSTRAINT PK_fbeventrefs PRIMARY KEY  CLUSTERED 
	(
		fbid,
		eventid
	)  

ALTER TABLE freebusy WITH NOCHECK ADD 
	CONSTRAINT PK_freebusy PRIMARY KEY  CLUSTERED 
	(
		fbid
	)  

ALTER TABLE groupuserref WITH NOCHECK ADD 
	CONSTRAINT PK_groupuserref PRIMARY KEY  CLUSTERED 
	(
		groupid,
		userid
	)  

ALTER TABLE invited WITH NOCHECK ADD 
	CONSTRAINT PK_invited PRIMARY KEY  CLUSTERED 
	(
		invitedid,
		eventid
	)  

ALTER TABLE subscribegroup WITH NOCHECK ADD 
	CONSTRAINT PK_subscribegroup PRIMARY KEY  CLUSTERED 
	(
		userid,
		groupid
	)  

ALTER TABLE subscribeuser WITH NOCHECK ADD 
	CONSTRAINT PK_subscribeuser PRIMARY KEY  CLUSTERED 
	(
		userid,
		subuser
	)  

ALTER TABLE userpref WITH NOCHECK ADD 
	CONSTRAINT PK_userpref PRIMARY KEY  CLUSTERED 
	(
		userid,
		prefid
	)  

ALTER TABLE users WITH NOCHECK ADD 
	CONSTRAINT PK__users__5F141958 PRIMARY KEY  CLUSTERED 
	(
		userid
	)  

 CREATE  INDEX bwri ON bywhat(ruleid) 

ALTER TABLE dbsetup ADD 
	CONSTRAINT DF_dbsetup_dblanguage DEFAULT ('english') FOR dblanguage,
	CONSTRAINT DF_dbsetup_calendartype DEFAULT ('gregorian') FOR calendartype

 CREATE  INDEX ekei ON event_keywords(eventid) 

 CREATE  INDEX ekki ON event_keywords(keywordid) 

 CREATE  INDEX ere ON eventrefs(eventid) 

 CREATE  INDEX eru ON eventrefs(userid) 

ALTER TABLE keywords ADD 
	CONSTRAINT DF__keywords__public__03A67F89 DEFAULT ('T') FOR publicf

 CREATE  INDEX kww ON keywords(word) 

 CREATE  INDEX kwc ON keywords(creator) 

 CREATE  INDEX kwp ON keywords(publicf) 

 CREATE  INDEX la ON locations(address) 

 CREATE  INDEX lc ON locations(creator) 

 CREATE  INDEX lp ON locations(publicf) 

ALTER TABLE recurrence_rules ADD 
	CONSTRAINT DF__recurrenc__multi__7DEDA633 DEFAULT (1) FOR multiplier,
	CONSTRAINT DF__recurrence__wkst__7EE1CA6C DEFAULT ('SU') FOR wkst

 CREATE  INDEX rrud ON recurrence_rules(untildate) 

ALTER TABLE sponsors ADD 
	CONSTRAINT DF__sponsors__sponso__086B34A6 DEFAULT ('') FOR sponsorname,
	CONSTRAINT DF__sponsors__public__095F58DF DEFAULT ('T') FOR publicf

 CREATE  INDEX sn ON sponsors(sponsorname) 

 CREATE  INDEX sc ON sponsors(creator) 

 CREATE  INDEX sp ON sponsors(publicf) 

ALTER TABLE timezone ADD 
	CONSTRAINT IX_timezone_tzname UNIQUE  NONCLUSTERED 
	(
		tzname
	)  

ALTER TABLE events2 ADD 
	CONSTRAINT DF__events2__status__1D66518C DEFAULT ('F') FOR status,
	CONSTRAINT chk_publicf CHECK (publicf = 'F' or publicf = 'T'),
	CONSTRAINT chk_status CHECK (status = 'P' or (status = 'C' or (status = 'F' or status = 'T')))

ALTER TABLE auth ADD 
	CONSTRAINT DF__authoriza__useri__351DDF8C DEFAULT ('') FOR username

ALTER TABLE events ADD 
	CONSTRAINT DF__events__status__4183B671 DEFAULT ('F') FOR status,
	CONSTRAINT DF_events_eventtype DEFAULT ('e') FOR eventtype

 CREATE  INDEX esd ON events(startdate) 

 CREATE  INDEX eed ON events(enddate) 

 CREATE  INDEX esh ON events(shortdesc) 

 CREATE  INDEX est ON events(status) 

 CREATE  INDEX eli ON events(locationid) 

 CREATE  INDEX esi ON events(sponsorid) 

 CREATE  INDEX ecr ON events(creator) 

 CREATE  INDEX rdrsd ON recurrence_dates(recurstartdate) 

 CREATE  INDEX rdred ON recurrence_dates(recurenddate) 

ALTER TABLE cars ADD 
	CONSTRAINT DF_cars_rights DEFAULT (1) FOR rights,
	CONSTRAINT DF_cars_calsubscribe DEFAULT (0) FOR calsubscribe

ALTER TABLE invited ADD 
	CONSTRAINT DF_invited_partstat DEFAULT ('n') FOR partstat,
	CONSTRAINT DF_invited_role DEFAULT ('o') FOR role,
	CONSTRAINT DF_invited_rsvp DEFAULT (0) FOR rsvp

ALTER TABLE users ADD 
	CONSTRAINT DF_users_usertype DEFAULT ('i') FOR usertype,
	CONSTRAINT DF_users_nbrevents DEFAULT (0) FOR nbrevents,
	CONSTRAINT DF_users_nbrmb DEFAULT (0) FOR nbrmb

 CREATE  UNIQUE  INDEX uu ON users(username) 

ALTER TABLE events2 ADD 
	 FOREIGN KEY 
	(
		locationid
	) REFERENCES locations (
		locationid
	),
	 FOREIGN KEY 
	(
		sponsorid
	) REFERENCES sponsors (
		sponsorid
	)

ALTER TABLE auth ADD 
	CONSTRAINT FK_auth_timezone FOREIGN KEY 
	(
		tzname
	) REFERENCES timezone (
		tzname
	)

ALTER TABLE events ADD 
	CONSTRAINT FK_events_evlong_enum FOREIGN KEY 
	(
		longvalue
	) REFERENCES evlong_enum (
		evlongid
	) ON DELETE CASCADE  ON UPDATE CASCADE ,
	CONSTRAINT FK_events_evstatus_enum FOREIGN KEY 
	(
		status
	) REFERENCES evstatus_enum (
		evstatusid
	) ON DELETE CASCADE  ON UPDATE CASCADE ,
	CONSTRAINT FK_events_evtype_enum FOREIGN KEY 
	(
		eventtype
	) REFERENCES evtype_enum (
		evtypeid
	) ON DELETE CASCADE  ON UPDATE CASCADE ,
	CONSTRAINT FK_events_timezone FOREIGN KEY 
	(
		tzname
	) REFERENCES timezone (
		tzname
	) ON DELETE CASCADE  ON UPDATE CASCADE ,
	CONSTRAINT FK_events_auth FOREIGN KEY 
	(
		creator
	) REFERENCES auth (
		username
	) ON DELETE CASCADE  ON UPDATE CASCADE 

ALTER TABLE groups ADD 
	CONSTRAINT FK_groups_groups FOREIGN KEY 
	(
		parentgroupid
	) REFERENCES groups (
		groupid
	),
	CONSTRAINT FK_groups_auth FOREIGN KEY 
	(
		creator
	) REFERENCES auth (
		username
	)

ALTER TABLE attachments ADD 
	CONSTRAINT FK_attachments_events FOREIGN KEY 
	(
		eventid
	) REFERENCES events (
		eventid
	) ON DELETE CASCADE  ON UPDATE CASCADE 

ALTER TABLE extension ADD 
	CONSTRAINT FK_Extension_events FOREIGN KEY 
	(
		eventid
	) REFERENCES events (
		eventid
	) ON DELETE CASCADE  ON UPDATE CASCADE 

ALTER TABLE groupeventrefs ADD 
	CONSTRAINT FK_groupeventrefs_events FOREIGN KEY 
	(
		eventid
	) REFERENCES events (
		eventid
	) ON DELETE CASCADE  ON UPDATE CASCADE ,
	CONSTRAINT FK_groupeventrefs_groups FOREIGN KEY 
	(
		groupid
	) REFERENCES groups (
		groupid
	) ON DELETE CASCADE  ON UPDATE CASCADE 

ALTER TABLE recurrence_dates ADD 
	 FOREIGN KEY 
	(
		eventid
	) REFERENCES events (
		eventid
	)

ALTER TABLE alarms ADD 
	CONSTRAINT FK_alarms_events FOREIGN KEY 
	(
		eventid
	) REFERENCES events (
		eventid
	) ON DELETE CASCADE  ON UPDATE CASCADE ,
	CONSTRAINT FK_alarms_users FOREIGN KEY 
	(
		userid
	) REFERENCES users (
		userid
	) ON DELETE CASCADE  ON UPDATE CASCADE 

ALTER TABLE cars ADD 
	CONSTRAINT FK_cars_carperm_enum FOREIGN KEY 
	(
		permission
	) REFERENCES carperm_enum (
		carpermid
	) ON DELETE CASCADE  ON UPDATE CASCADE ,
	CONSTRAINT FK_cars_groups FOREIGN KEY 
	(
		groupid
	) REFERENCES groups (
		groupid
	) ON DELETE CASCADE  ON UPDATE CASCADE ,
	CONSTRAINT FK_cars_users FOREIGN KEY 
	(
		designatee
	) REFERENCES users (
		userid
	)

ALTER TABLE fbeventrefs ADD 
	CONSTRAINT FK_fbeventrefs_events FOREIGN KEY 
	(
		eventid
	) REFERENCES events (
		eventid
	) ON DELETE CASCADE  ON UPDATE CASCADE ,
	CONSTRAINT FK_fbeventrefs_freebusy FOREIGN KEY 
	(
		fbid
	) REFERENCES freebusy (
		fbid
	) ON DELETE CASCADE  ON UPDATE CASCADE 

ALTER TABLE freebusy ADD 
	CONSTRAINT FK_freebusy_fbtype_enum FOREIGN KEY 
	(
		fbtype
	) REFERENCES fbtype_enum (
		fbtype
	) ON DELETE CASCADE  ON UPDATE CASCADE ,
	CONSTRAINT FK_freebusy_groups FOREIGN KEY 
	(
		groupid
	) REFERENCES groups (
		groupid
	),
	CONSTRAINT FK_freebusy_users FOREIGN KEY 
	(
		userid
	) REFERENCES users (
		userid
	) ON DELETE CASCADE  ON UPDATE CASCADE 

ALTER TABLE groupuserref ADD 
	CONSTRAINT FK_groupuserref_groups FOREIGN KEY 
	(
		groupid
	) REFERENCES groups (
		groupid
	),
	CONSTRAINT FK_groupuserref_users FOREIGN KEY 
	(
		userid
	) REFERENCES users (
		userid
	) ON DELETE CASCADE  ON UPDATE CASCADE 

ALTER TABLE invited ADD 
	CONSTRAINT FK_invited_events FOREIGN KEY 
	(
		eventid
	) REFERENCES events (
		eventid
	) ON DELETE CASCADE  ON UPDATE CASCADE ,
	CONSTRAINT FK_invited_invrole_enum FOREIGN KEY 
	(
		role
	) REFERENCES invrole_enum (
		invroleid
	) ON DELETE CASCADE  ON UPDATE CASCADE ,
	CONSTRAINT FK_invited_auth FOREIGN KEY 
	(
		creator
	) REFERENCES auth (
		username
	),
	CONSTRAINT FK_invited_users FOREIGN KEY 
	(
		invitedid
	) REFERENCES users (
		userid
	) ON DELETE CASCADE  ON UPDATE CASCADE 

ALTER TABLE subscribegroup ADD 
	CONSTRAINT FK_subscribegroup_groups FOREIGN KEY 
	(
		groupid
	) REFERENCES groups (
		groupid
	),
	CONSTRAINT FK_subscribegroup_users FOREIGN KEY 
	(
		userid
	) REFERENCES users (
		userid
	) ON DELETE CASCADE  ON UPDATE CASCADE 

ALTER TABLE subscribeuser ADD 
	CONSTRAINT FK_subscribeuser_users FOREIGN KEY 
	(
		userid
	) REFERENCES users (
		userid
	) ON DELETE CASCADE  ON UPDATE CASCADE ,
	CONSTRAINT FK_subscribeuser_users1 FOREIGN KEY 
	(
		subuser
	) REFERENCES users (
		userid
	)

ALTER TABLE userpref ADD 
	CONSTRAINT FK_userpref_preferences FOREIGN KEY 
	(
		prefid
	) REFERENCES preferences (
		prefid
	) ON DELETE CASCADE  ON UPDATE CASCADE ,
	CONSTRAINT FK_userpref_users FOREIGN KEY 
	(
		userid
	) REFERENCES users (
		userid
	) ON DELETE CASCADE  ON UPDATE CASCADE 

ALTER TABLE users ADD 
	CONSTRAINT FK_users_cars FOREIGN KEY 
	(
		mblimit
	) REFERENCES cars (
		userid
	) ON DELETE CASCADE  ON UPDATE CASCADE ,
	CONSTRAINT FK_users_auth FOREIGN KEY 
	(
		username
	) REFERENCES auth (
		username
	),
	CONSTRAINT FK_users_usertype_enum FOREIGN KEY 
	(
		usertype
	) REFERENCES usertype_enum (
		usertypeid
	) ON DELETE CASCADE  ON UPDATE CASCADE 
