package edu.washington.cac.calfacade.shared;

/** A read-only implementation of UserAuth which can be used by applications
 * which want to expose the current access level safely to the outside world.
 *
 * Web-applications for example should not expose the UserAuth methods to
 * the struts request handling mechanism.
 *
 * @author Mike Douglass douglm@rpi.edu
 * @version 2.2
 */
public class UserAuthRO implements UserAuth {
  /** Current user access
   */
  private int curUsertype = noPrivileges;

  private String curUser;

  /** Create the object with an access level.
   *
   * @param  userid    user whose access we are setting
   * @param  val       int sum  of allowable access.
   * @exception CalFacadeException If there's a problem
   */
  public UserAuthRO(String userid, int val) {
    curUser = userid;
    curUsertype = val;
  }

  public void initialise(String userid, Object val) throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }

  /** Initialise the implementing object with an access level.
   *
   * <p>This is not all that well-defined. This area falls somewhere
   * between the back-end and the front-end, depending upon how a site
   * implements its authorisation.
   *
   * <p>This allows role-based implementations using the standard servlet
   * authorization model to indicate what roles a user has. This may not get
   * called or it may be called and ignored.
   *
   * <p>This method should not update any underlying directory.
   *
   * <p>Any implementation is free to ignore the call altogether.
   * Alternatively an implementation may choose to base the access on the
   * supplied user and ignore the supplied access.
   *
   * @param  userid    user whose access we are setting
   * @param  val       int sum  of allowable access.
   * @exception CalFacadeException If there's a problem
   */
  public void initialise(String userid, int val) throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }

  /** ===================================================================
   *  The following return the state of the current user.
   *  =================================================================== */

  /** Return the current userid. If non-null this object has been
   * initialised otherwise one of the initialsie methods must be called.
   *
   * @return String          non-null for initialised object.
   * @exception CalFacadeException If there's a problem
   */
   public String getUserid() throws CalFacadeException {
     return curUser;
   }

  /** Return a read only object represeting the state of the current user.
   *
   * @return UserAuthRO        object representing user state
   * @exception CalFacadeException If there's a problem
   */
  public UserAuthRO getUserAuthRO() throws CalFacadeException {
    return this;
  }

  /** Return the type of the current user.
   *
   * @return int        user type as defined above,
   * @exception CalFacadeException If there's a problem
   */
  public int getUsertype() throws CalFacadeException {
    return curUsertype;
  }

  /** Check for priv user
   *
   * @return boolean    true for super user
   * @exception CalFacadeException If there's a problem
   */
  public boolean isSuperUser() throws CalFacadeException {
    return (curUsertype & superUser) != 0;
  }

  /** Check for alert user
   *
   * @return boolean    true for alert user
   * @exception CalFacadeException If there's a problem
   */
  public boolean isAlertUser() throws CalFacadeException {
    return (curUsertype & alertUser) != 0;
  }

  /** Check for public events owner user
   *
   * @return boolean    true for public events owner user
   * @exception CalFacadeException If there's a problem
   */
  public boolean isOwnerUser() throws CalFacadeException {
    return (curUsertype & publicEventUser) != 0;
  }

  /** Check for content admin user
   *
   * @return boolean    true for content admin user
   * @exception CalFacadeException If there's a problem
   */
  public boolean isContentAdminUser() throws CalFacadeException {
    return (curUsertype & contentAdminUser) != 0;
  }

  /** ===================================================================
   *  The following should not change the state of the current users
   *  access which is set and retrieved with the above methods.
   *  =================================================================== */

  /** Show whether user entries can be displayed or modified with this
   * class. Some sites may use other mechanisms.
   *
   * @return boolean    true if user maintenance is implemented.
   */
  public boolean getUserMaintOK() {
    return false;
  }

  /** Return the type of the user.
   *
   * @param  userid     String user id
   * @return int        user type as defined above,
   * @exception CalFacadeException If there's a problem
   */
  public int getUsertype(String userid) throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }

  /** Set the type of the user.
   *
   * @param  userid     String user id
   * @param  utype      int user type as defined above,
   * @exception CalFacadeException If there's a problem
   */
  public void setUsertype(String userid, int utype)
          throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }

  /** Adjust the user type to take account of site specific requirements.
   *
   * <p>For example, some sites may allow any user who can add public events
   * the authority to add alerts. Others may wish to keep those roles
   * separate.
   *
   * <p>This routine also should enure all the super user privileges are
   * set.
   *
   * @param userType    int unadjusted user type.
   * @return int   adjusted user type.
   * @exception CalFacadeException   For invalid usertype values.
   */
  public int adjustUsertype(int userType) throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }

  /** Just see if the user has any special privileges.
   * Same as getUserType(userid) != noPrivileges;
   *
   * @param  userid     String user id
   * @return boolean true if the user has any special privileges
   * @exception CalFacadeException If there's a problem
   */
  public boolean isAuthorised(String userid) throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }

  /** Check for priv user
   * Same as getUserType(userid) == superUser;
   *
   * @param  userid     String user id
   * @return boolean    true for super user
   * @exception CalFacadeException If there's a problem
   */
  public boolean isSuperUser(String userid) throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }

  /** Remove any special authorisation for this user
   *
   * @param  val      AuthUserVO users entry
   * @exception CalFacadeException If there's a problem
   */
  public void removeAuth(AuthUserVO val) throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }

  /** Update the user entry
   *
   * @param  val      AuthUserVO users entry
   */
  public void updateUser(AuthUserVO val) throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }

  /** Return the given user. Will always return an entry (except for
   * exceptional conditions.) An unauthorsed user will have a usertype of
   * noPrivileges.
   *
   * @param  userid        String user id
   * @return AuthUserVO    users entry
   * @exception CalFacadeException If there's a problem
   */
  public AuthUserVO getUser(String userid) throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }

  /** Return a collection of all authorised users
   *
   * @return AuthUserVO[]    users with any special authorisation.
   * @exception CalFacadeException If there's a problem
   */
  public AuthUserVO[] getAll() throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }

  /* ====================================================================
   *                       Preferences methods
   * ==================================================================== */

  /** Set the value in the user record. If it's changed update the database.
   */
  public void setAutoAddKeywords(AuthUserVO user, boolean val)
      throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }

  /** Add a keyword key to the preferred keywords. Return true if it was
   * added, false if it was in the list.
   */
  public boolean addKeyword(AuthUserVO user, int key)
      throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }

  /** Remove a keyword preference for the given user if supplied or all users
   * if user is null.
   *
   * @param user   AuthUserVO entry for user or null for all users
   * @param key    keyword id in the entry to remove
   */
  public void removeKeyword(AuthUserVO user, int key)
      throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }

  /** Set the value in the user record. If it's changed update the database.
   */
  public void setAutoAddLocations(AuthUserVO user, boolean val)
      throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }

  /** Add a location key to the preferred locations. Return true if it was
   * added, false if it was in the list.
   */
  public boolean addLocation(AuthUserVO user, int key)
      throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }

  /** Remove a location preference for the given user if supplied or all users
   * if user is null.
   *
   * @param user   AuthUserVO entry for user or null for all users
   * @param key    location id in the entry to remove
   */
  public void removeLocation(AuthUserVO user, int key)
      throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }

  /** Set the value in the user record. If it's changed update the database.
   */
  public void setAutoAddSponsors(AuthUserVO user, boolean val)
      throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }

  /** Add a sponsor key to the preferred sponsors. Return true if it was
   * added, false if it was in the list.
   */
  public boolean addSponsor(AuthUserVO user, int key)
      throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }

  /** Remove a sponsor preference for the given user if supplied or all users
   * if user is null.
   *
   * @param user   AuthUserVO entry for user or null for all users
   * @param key    sponsor id in the entry to remove
   */
  public void removeSponsor(AuthUserVO user, int key)
      throws CalFacadeException {
    throw new CalFacadeException("Method not accessible");
  }
}
