package edu.washington.cac.calfacade.shared;

import java.io.Serializable;

/** Value object representing the sponsor of an event
 *
 * @author Mike Douglass
 * @version 1.0
 */
public class SponsorVO implements Comparable,Serializable {
  /** Any event id up to this is reserved.
   */
  public static final int maxReservedId = 3;

  private int sponsorid;
  private String name, phone, email, link;

  /** The person who created the sponsor */
  private UserVO creator;

  private boolean isPublic;

  public SponsorVO() {
  }

  /** Create a sponsor specifying all fields
   *
   *  @param sponsorid      int unique ID for the sponsor
   *  @param name           String Name of the sponsor
   *  @param phone          String Phone number
   *  @param email          String E-mail
   *  @param link           String URL with more info
   *  @param creator        UserVO person who created the event
   *  @param isPublic       boolean true if the event is viewable by everyone
   */
  public SponsorVO(int sponsorid,
                String name,
                String phone,
                String email,
                String link,
                UserVO creator,
                boolean isPublic) {
    this.sponsorid = sponsorid;
    this.name = name;
    this.phone = phone;
    this.email = email;
    this.link = link;
    this.creator = creator;
    this.isPublic = isPublic;
  }

  public void setId(int sponsorid) {
    this.sponsorid = sponsorid;
  }

  public int getId() {
    return sponsorid;
  }

  /** Set the name
   *
   * @param val    String name
   */
  public void setName(String val) {
    name = val;
  }

  /** Get the name
   *
   * @return String   name
   */
  public String getName() {
    return name;
  }

  public void setPhone(String val) {
    phone = val;
  }

  public String getPhone() {
    return phone;
  }

  public void setEmail(String val) {
    email = val;
  }

  public String getEmail() {
    return email;
  }

  public void setIsPublic(boolean val) {
    isPublic = val;
  }

  public boolean isPublic() {
    return isPublic;
  }

  /** Set the sponsor's URL
   *
   * @param link   String new URL
   */
  public void setLink(String link) {
    this.link = link;
  }

  public String getLink() {
    return link;
  }

  /** Set the creator
   *
   * @param val     UserVO creator of the sponsor
   */
  public void setCreator(UserVO val) {
    creator = val;
  }

  /**
   *
   * @return UserVO    creator of the sponsor
   */
  public UserVO getCreator() {
    return creator;
  }

  /**  Compares this object with the specified object for order.
   * Returns a negative integer, zero, or a positive integer as this object
   * is less than, equal to, or greater than the specified object.
   *
   */
  public int compareTo(Object o) {
    if (!(o instanceof SponsorVO)) {
      return -1;
    }

    SponsorVO that = (SponsorVO)o;

    if (name == null) {
      if (that.name == null) {
        return 0;
      }

      return -1;
    }

    return name.compareTo(that.name);
  }
}
