package edu.washington.cac.calfacade.shared;

import java.io.Serializable;

/** The location of an <code>Event</code>
 *
 *  @version 1.0
 */
public class LocationVO implements Comparable, Serializable {
  /** Any event id up to this is reserved.
   */
  public static final int maxReservedId = 3;

  private int locationid;
  private String address, subaddress, link;

  /** The person who created the location */
  private UserVO creator;

  private boolean isPublic;

  public LocationVO() {
  }

  /** create a location with all fields specified
   *
   *  @param locationid  int unique id
   *  @param address     main address
   *  @param subaddress  secondary address
   *  @param link        String URL with more info
   *  @param creator     UserVO user that created it
   *  @param isPublic    true if location is viewable by everyone
   */
  public LocationVO(int locationid,
                    String address,
                    String subaddress,
                    String link,
                    UserVO creator,
                    boolean isPublic) {
    this.locationid = locationid;
    this.address = address;
    this.subaddress = subaddress;
    this.link = link;
    this.creator = creator;
    this.isPublic = isPublic;
  }

  public void setId(int locationid) {
    this.locationid = locationid;
  }

  /** Get the unique id of the location
   *
   *  @return the unique id of the location
   */
  public int getId() {
    return locationid;
  }

  public void setAddress(String val) {
    address = val;
  }

  /** Get the main address of the location
      @return the main address of the location
    */
  public String getAddress() {
    return address;
  }

  public void setSubaddress(String val) {
    subaddress = val;
  }

  /** Get the secondary address of the location
      @return the secondary address of the location
   */
  public String getSubaddress() {
    return subaddress;
  }

  /**
    Set the Location's URL
    @param link The new URL
   */
  public void setLink(String link) {
    this.link = link;
  }

  /** Get the link for the location
        @return the link for the location
      */
  public String getLink() {
    return link;
  }

  public void setCreator(UserVO val) {
    creator = val;
  }

  /**
    @return UserVO     creator of the location
    */
  public UserVO getCreator() {
    return creator;
  }

  public void setIsPublic(boolean val) {
    isPublic = val;
  }

  /**
      Test whether the location is public
      @return whether the location is public
    */
  public boolean isPublic() {
    return isPublic;
  }

  /**  Compares this object with the specified object for order.
   * Returns a negative integer, zero, or a positive integer as this object
   * is less than, equal to, or greater than the specified object.
   *
   */
  public int compareTo(Object o) {
    if (!(o instanceof LocationVO)) {
      return -1;
    }

    LocationVO that = (LocationVO)o;

    if (address == null) {
      if (that.address == null) {
        return 0;
      }

      return -1;
    }

    return address.compareTo(that.address);
  }

  public String toString() {
    StringBuffer sb = new StringBuffer();

    sb.append("LocationVO{id=");
    sb.append(locationid);
    sb.append(", address=");
    sb.append(address);
    sb.append(", subaddress=");
    sb.append(subaddress);
    sb.append(", link=");
    sb.append(link);
    sb.append(", creator=");
    UserVO c = getCreator();
    if (c == null) {
      sb.append("null");
    } else {
      sb.append(c.getId());
    }
    sb.append("}");

    return sb.toString();
  }
}
