package edu.washington.cac.calfacade.shared;

import java.io.Serializable;

/** A keyword in UWCal. This value object does no consistency or validity
 * checking.
 *
 *  @version 1.0
 */
public class KeywordVO implements Comparable, Serializable {
  private int id;
  private String word;
  private String title;
  private String description;

  /** User who created this keyword */
  private UserVO creator;

  private boolean isPublic;

  public KeywordVO() {
  }

  /** Create a keyword by specifying all its fields

      @param id          Unique ID for the keyword
      @param word        String word
      @param title       String title
      @param description String long description for help
      @param isPublic Is the event viewable by everyone?
      @param creator     UserVO person who created the event
    */
  public KeywordVO(int id,
               String word,
               String title,
               String description,
               boolean isPublic,
               UserVO creator) {
    this.id = id;
    this.word = word;
    this.title = title;
    this.description = description;
    this.isPublic = isPublic;
    this.creator = creator;
  }

  /**
    Set the id for this keyword
    @param val    int Keyword id
   */
  public void setId(int val) {
    id = val;
  }

  /** Get the kwywords unique id
   *
   * @return int    the keywords unique id
   */
  public int getId() {
    return id;
  }

  /** Set the word
   *
   * @param val    String word
   */
  public void setWord(String val) {
    word = val;
  }

  /** Get the word
   *
   * @return String   word
   */
  public String getWord() {
    return word;
  }

  /** Set the keywords title
   *
   * @param val    String keywords title
   */
  public void setTitle(String val) {
    title = val;
  }

  /** Get the keyword's title
   *
   *  @return String   keyword's title
   */
  public String getTitle() {
    return title;
  }

  /** Set the keywords long description
   *
   * @param val    String keywords description
   */
  public void setDescription(String val) {
    description = val;
  }

  /** Get the keywords's long description
   *
   *  @return String   keywords's long description
   */
  public String getDescription() {
    return description;
  }

  /** Set the keyword public flag?
   *
   *  @param val    true if the keyword is public
   */
  public void setIsPublic(boolean val) {
    isPublic = val;
  }

  /** Is the keyword public?
   *
   *  @return boolean    true if the keyword is public
   */
  public boolean isPublic() {
    return isPublic;
  }

  /**
   * @param  val      UserVO keyword's creator
   */
  public void setCreator(UserVO val) {
    creator = val;
  }

  /**
   * @return UserVO     keyword's creator
   */
  public UserVO getCreator() {
    return creator;
  }

  /* ====================================================================
   *                        Object methods
   * ==================================================================== */

  public String toString() {
    StringBuffer sb = new StringBuffer();

    sb.append("KeywordVO{id=");
    sb.append(id);
    sb.append(", word=");
    sb.append(word);
    sb.append(", isPublic=");
    sb.append(isPublic);
    sb.append("}");

    return sb.toString();
  }

  /** The id does not take part in these comparisons because we're presumably
   * doing this to see if two objects are the same without doing a db retrieval.
   * That is, one of the objects in a comparison may not have the id set.
   *
   * <p>This is relevant for hashcode as the equals method requires that
   * hashcode return equal values for both objects in a comparison that are
   * to be considered equal.
   *
   * <p>As we have both objects to hand in the equals method we can check to
   * see if both ids are non-zero and use them in the comparison.
   */
  public int hashCode() {
    int hc = 1;

    if (id != 0) {
      hc *= id;
    }

    if (word != null) {
      hc *= word.hashCode();
    }

    if (title != null) {
      hc *= title.hashCode();
    }

    if (description != null) {
      hc *= description.hashCode();
    }

    if (creator != null) {
      hc *= creator.hashCode();
    }

    if (isPublic) {
      hc *= 2;
    }

    return hc;
  }

  public boolean equals(Object obj) {
    if (!(obj instanceof KeywordVO)) {
      return false;
    }

    KeywordVO that = (KeywordVO)obj;

    if ((id != 0) && (that.id != 0)) {
      if (id != that.id) {
        return false;
      }
    }

    if (word == null) {
      if (that.word != null) {
        return false;
      }
    } else if (!word.equals(that.word)) {
      return false;
    }

    if (title == null) {
      if (that.title != null) {
        return false;
      }
    } else if (!title.equals(that.title)) {
      return false;
    }

    if (description == null) {
      if (that.description != null) {
        return false;
      }
    } else if (!description.equals(that.description)) {
      return false;
    }

    if (creator == null) {
      if (that.creator != null) {
        return false;
      }
    } else if (!creator.equals(that.creator)) {
      return false;
    }

    return isPublic = that.isPublic;
  }

  /**  Compares this object with the specified object for order.
   * Returns a negative integer, zero, or a positive integer as this object
   * is less than, equal to, or greater than the specified object.
   *
   */
  public int compareTo(Object o) {
    if (!(o instanceof KeywordVO)) {
      return -1;
    }

    KeywordVO that = (KeywordVO)o;

    if (word == null) {
      if (that.word == null) {
        return 0;
      }

      return -1;
    }

    return word.compareTo(that.word);
  }
}
