package edu.washington.cac.calfacade.shared;

import java.io.Serializable;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.NamingEnumeration;

/** Keyword attributes.
 *
 *  @version 1.0
 */
public class KeywordAttrsVO implements Serializable {
  /** Id of the attributes */
  private int id;

  /** Id of the corresponding keyword */
  private int keywordid;

  /** the attributes themselves */
  private Attributes attrs;

  public KeywordAttrsVO() {
  }

  /** Create a keyword attributes entry by specifying all the fields.

      @param id          Unique ID for the entry
      @param keywordid   id of the keyword
      @param attrs       Attrbutes
    */
  public KeywordAttrsVO(int id,
                        int keywordid,
                        Attributes attrs) {
    this.id = id;
    this.keywordid = keywordid;
    this.attrs = attrs;
  }

  /** Set the id for this keyword attributes entry
   *
   * @param val    unique id of the Keyword attributes
   */
  public void setId(int val) {
    id = val;
  }

  /** Get the keyword attributes unique id
   *
   * @return int    the keyword attributes unique id
   */
  public int getId() {
    return id;
  }

  /** Set the id of the corresponding keyword for this keyword attributes entry
   *
   * @param val    int Keyword id
   */
  public void setKeywordid(int val) {
    keywordid = val;
  }

  /** Get the kwywords unique id
   *
   * @return int    the keywords unique id
   */
  public int getKeywordid() {
    return keywordid;
  }

  /** Set the attrs
   *
      @param val       Attrbutes
   */
  public void setAttrs(Attributes val) {
    attrs = val;
  }

  /** Get the attributes
   *
   * @return Attributes   attributes
   */
  public Attributes getAttrs() {
    return attrs;
  }

  /* ====================================================================
   *                          Convenience methods
   * ==================================================================== */

  /** Add an attribute
   *
   * @param name   String attribute name
   * @param val    String value
   */
  public void addAttrVal(String name, String val) {
    if (attrs == null) {
      attrs = new BasicAttributes();
    }

    Attribute attr = attrs.get(name);

    if (attr == null) {
      attrs.put(name, val);
      return;
    }

    attr.add(val);
  }

  /** Remove an attribute value
   *
   * @param name   String attribute name
   * @param val    String value
   */
  public void removeAttrVal(String name, String val) {
    if (attrs == null) {
      return;
    }

    Attribute attr = attrs.get(name);

    if (attr == null) {
      return;
    }

    attr.remove(val);
  }

  /** Remove an attribute and all its values
   *
   * @param name   String attribute name
   */
  public void removeAttr(String name) {
    if (attrs == null) {
      return;
    }

    attrs.remove(name);
  }

  /** Get an attributes values
   *
   * @param name      String attribute name
   * @return String[] values
   */
  public String[] getAttrVals(String name) throws Throwable {
    if (attrs == null) {
      return null;
    }

    Attribute attr = attrs.get(name);

    if (attr == null) {
      return null;
    }

    String[] vals = new String[attr.size()];

    for (int i = 0; i < attr.size(); i++) {
      vals[i] = (String)attr.get(i);
    }

    return vals;
  }

  /** See if this has a matching name and value
   *
   * @param name   String attribute name
   * @param val    String value
   */
  public boolean isMatching(String name, String val) {
    if (attrs == null) {
      return false;
    }

    Attribute attr = attrs.get(name);

    if (attr == null) {
      return false;
    }

    return attr.contains(val);
  }

}
