package edu.washington.cac.calfacade.shared;

import java.io.Serializable;

/** Represents a selection of a public event by a particular user.
 *
 *  @author Mike Douglass douglm@rpi.edu
 *  @version 1.0
 */
public class EventRefVO implements Serializable {
  /** Internal db id of the event */
  private int eventid;

  /** Name of the user */
  private UserVO user;

  /** the default purpose ('E' for 'explicitly added') */
  private static final char DefaultPurpose = 'E';

  /** A one-character code for the 'purpose' of the eventref */
  private char purpose = DefaultPurpose;

  /** Constructor setting all fields.
   *
   * @param eventid    int id of the event
   * @param user       UserVO user to create the eventref for
   * @param purpose    A simple code explaining why this eventref exists
   */
  public EventRefVO(int eventid, UserVO user, char purpose) {
    this.eventid = eventid;
    this.user = user;
    this.purpose = purpose;
  }

  /** Create an EventRefVO with defaulted purpose
   *
   * @param eventid    int id of the event
   * @param user       UserVO user to create the eventref for
   */
  public EventRefVO(int eventid, UserVO user) {
    this(eventid, user, DefaultPurpose);
  }

  /** set the eventid
   *
   * @param val  int event id.
   */
  public void setEventid(int val) {
    eventid = val;
  }

  /** Get the eventid
   *
   * @return int     event id.
   */
  public int getEventid() {
    return eventid;
  }

  /** set the user name
   *
   * @param val  UserVO user
   */
  public void setUser(UserVO val) {
    user = val;
  }

  /** Get the user name
   *
   * @return UserVO     user
   */
  public UserVO getUser() {
    return user;
  }

  /**  set the purpose of this reference
   *
   * @param val    char purpose of this reference
   */
  public void setPurpose(char val) {
    purpose = val;
  }

  /**  Get the purpose of this reference
   *
   * @return char    purpose of this reference
   */
  public char getPurpose() {
    return purpose;
  }
}
