package edu.washington.cac.calfacade.shared;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.util.Vector;

/** Value object to represent an authorised calendar user - that is a user
 * with some special privilege. This could also be represented by users
 * with roles.
 *
 *   @author Mike Douglass douglm@rpi.edu
 *  @version 1.0
 */
public class AuthUserVO implements Serializable {
  /* key */
  private int userid;
  /* account name */
  private String account;
  private int usertype;
  private String lastname;
  private String firstname;
  private String uphone;
  private String uemail;
  private String dept;

  /** If true automatically add keywords to the preferred list
   */
  private boolean autoAddKeywords;

  /** Keys of this users preferred keywords.
   */
  private int[] preferredKeywords;

  /** If true automatically add locations to the preferred list
   */
  private boolean autoAddLocations;

  /** Keys of this users preferred locations.
   */
  private int[] preferredLocations;

  /** If true automatically add sponsors to the preferred list
   */
  private boolean autoAddSponsors;

  /** Keys of this users preferred sponsors.
   */
  private int[] preferredSponsors;

  /** Create an authuser vo by specifying all its fields
   *
   * @param  userid         int user id
   * @param  account        String user name
   * @param  usertype       int type of user
   * @param  lastname       String
   * @param  firstname      String
   * @param  uphone         String
   * @param  uemail         String
   * @param  dept           String
    */
  public AuthUserVO(int userid,
                    String account,
                    int usertype,
                    String lastname,
                    String firstname,
                    String uphone,
                    String uemail,
                    String dept) {
    this.userid = userid;
    this.account = account;
    this.usertype = usertype;
    this.lastname = lastname;
    this.firstname = firstname;
    this.uphone = uphone;
    this.uemail = uemail;
    this.dept = dept;
  }

  public void setUserid(int val) {
    userid = val;
  }

  public int getUserid() {
    return userid;
  }

  public void setAccount(String val) {
    account = val;
  }

  public String getAccount() {
    return account;
  }

  public void setUsertype(int val) {
    usertype = val;
  }

  public int getUsertype() {
    return usertype;
  }

  public void setLastname(String val) {
    lastname = val;
  }

  public String getLastname() {
    return lastname;
  }

  public void setFirstname(String val) {
    firstname = val;
  }

  public String getFirstname() {
    return firstname;
  }

  public void setUphone(String val) {
    uphone = val;
  }

  public String getUphone() {
    return uphone;
  }

  public void setUemail(String val) {
    uemail = val;
  }

  public String getUemail() {
    return uemail;
  }

  public void setDept(String val) {
    dept = val;
  }

  public String getDept() {
    return dept;
  }

  /* ====================================================================
   *                          Preferences methods
   * ==================================================================== */

  /** If true automatically add keywords to the preferred list
   */
  public void setAutoAddKeywords(boolean val) {
    autoAddKeywords = val;
  }

  public boolean getAutoAddKeywords() {
    return autoAddKeywords;
  }

  public void setPreferredKeywords(int[] val) {
    preferredKeywords = val;
  }

  public int[] getPreferredKeywords() {
    return preferredKeywords;
  }

  /** If true automatically add locations to the preferred list
   */
  public void setAutoAddLocations(boolean val) {
    autoAddLocations = val;
  }

  public boolean getAutoAddLocations() {
    return autoAddLocations;
  }

  public void setPreferredLocations(int[] val) {
    preferredLocations = val;
  }

  public int[] getPreferredLocations() {
    return preferredLocations;
  }

  /** If true automatically add sponsors to the preferred list
   */
  public void setAutoAddSponsors(boolean val) {
    autoAddSponsors = val;
  }

  public boolean getAutoAddSponsors() {
    return autoAddSponsors;
  }

  public void setPreferredSponsors(int[] val) {
    preferredSponsors = val;
  }

  public int[] getPreferredSponsors() {
    return preferredSponsors;
  }

  /* ====================================================================
   *                      Convenience methods
   * ==================================================================== */

  public boolean isAlertUser() {
    return ((usertype & UserAuth.alertUser) != 0);
  }

  public boolean isPublicEventUser() {
    return ((usertype & UserAuth.publicEventUser) != 0);
  }

  public boolean isSuperUser() {
    return ((usertype & UserAuth.superUser) != 0);
  }

  /** Add a keyword key to the preferred keywords. Return true if it was
   * added, false if it was in the list.
   */
  public boolean addKeyword(int key) {
    int[] newkeys = addKey(key, preferredKeywords);
    if (newkeys == null) {
      return false;
    }

    preferredKeywords = newkeys;
    return true;
  }

  /** Add a location key to the preferred locations. Return true if it was
   * added, false if it was in the list.
   */
  public boolean addLocation(int key) {
    int[] newkeys = addKey(key, preferredLocations);
    if (newkeys == null) {
      return false;
    }

    preferredLocations = newkeys;
    return true;
  }

  /** Add a sponsor key to the preferred sponsors. Return true if it was
   * added, false if it was in the list.
   */
  public boolean addSponsor(int key) {
    int[] newkeys = addKey(key, preferredSponsors);
    if (newkeys == null) {
      return false;
    }

    preferredSponsors = newkeys;
    return true;
  }

  /* ====================================================================
   *                        private methods
   * ==================================================================== */

  /** Call to add a value to the keyArray. Returns with null if the value is
   * already present or with a new array.
   *
   * <p>Entries are not sorted, we assume the results are soted alphabetically.
   */
  private int[] addKey(int key, int[] keyArray) {
    if (keyArray == null) {
      return new int[]{key};
    }

    int len = keyArray.length;

    for (int i = 0; i < len; i++) {
      if (keyArray[i] == key) {
        return null;
      }
    }

    int[] newkeys = new int[len + 1];

    System.arraycopy(keyArray, 0, newkeys, 0, len);
    newkeys[len] = key;

    return newkeys;
  }

  /* ====================================================================
   *                        Object methods
   * ==================================================================== */

  public String toString() {
    StringBuffer sb = new StringBuffer();

    sb.append("AuthUserVO{id=");
    sb.append(userid);
    sb.append(", account=");
    sb.append(account);
    sb.append(", usertype=");
    sb.append(usertype);
    sb.append("}");

    return sb.toString();
  }
}
