package edu.washington.cac.calfacade.shared;

/** An object representing a calendar admin group.
 *
 * @author Mike Douglass douglm@rpi.edu
 * @version 2.2
 */
public class AdminGroupVO extends AdminGroupROVO {
  /** Create a new object.
   */
  public AdminGroupVO() {
  }

  /** Create a new object.
   *
   * @param  name          String group name
   * @param  description   String group description
   * @param  groupOwnerid  String id of user who owns the group.
   * @param  ownerid       String group ownerid - the owner of events.
   */
  public AdminGroupVO(String name,
                     String description,
                     String groupOwnerid,
                     String ownerid,
                     String[] members) {
    super(name, description, groupOwnerid, ownerid, members);
  }

  /** Set the name of the group.
   *
   * @param   val     String group name.
   * @exception CalFacadeException If there's a problem
   */
  public void setName(String val) throws CalFacadeException {
    name = val;
  }

  /** Set the description of the group.
   *
   * @param   val     String group description.
   * @exception CalFacadeException If there's a problem
   */
  public void setDescription(String val) throws CalFacadeException {
    description = val;
  }

  /** Set the id of the group owner.
   *
   * @param   val     String group owner.
   * @exception CalFacadeException If there's a problem
   */
  public void setGroupOwnerid(String val) throws CalFacadeException {
    groupOwnerid = val;
  }

  /** Set the ownerid of the group.
   *
   * @param   val     String group ownerid.
   * @exception CalFacadeException If there's a problem
   */
  public void setOwnerid(String val) throws CalFacadeException {
    ownerid = val;
  }

  /** Set the members of the group.
   *
   * @param   val     String group members.
   * @exception CalFacadeException If there's a problem
   */
  public void setMembers(String[] val) throws CalFacadeException {
    members = val;
  }

  /** get a read-only version
   *
   * @return AdminGroupROVO   read only version of this object
   */
  public AdminGroupROVO getAdminGroupROVO() {
    return new AdminGroupROVO(name, description, groupOwnerid,
                              ownerid, members);
  }

}
