package edu.washington.cac.calfacade.shared;

/** A read-only object representing a calendar admin group.
 * Used for web applications to protect the data from the request stream.
 *
 * @author Mike Douglass douglm@rpi.edu
 * @version 2.2
 */
public class AdminGroupROVO {
  protected String name;

  protected String description;

  protected String groupOwnerid;

  protected String ownerid;

  /** ids of the members of the group
   */
  protected String[] members;

  /** Only of use to subclasses with set methods
   */
  public AdminGroupROVO() {
  }

  /** Create a new read only object.
   *
   * @param  name          String group name
   * @param  description   String group description
   * @param  groupOwnerid  String id of user who owns the group.
   * @param  ownerid       String group ownerid - the owner of events.
   */
  public AdminGroupROVO(String name,
                       String description,
                       String groupOwnerid,
                       String ownerid,
                       String[] members) {
    this.name = name;
    this.description = description;
    this.groupOwnerid = groupOwnerid;
    this.ownerid = ownerid;
    this.members = members;
  }

  /** Return the name of the group.
   *
   * @return String        group name
   * @exception CalFacadeException If there's a problem
   */
  public String getName() throws CalFacadeException {
    return name;
  }

  /** Return the description of the group.
   *
   * @return String        group description
   * @exception CalFacadeException If there's a problem
   */
  public String getDescription() throws CalFacadeException {
    return description;
  }

  /** Return the id of the group owner.
   *
   * @return String        group ownerid
   * @exception CalFacadeException If there's a problem
   */
  public String getGroupOwnerid() throws CalFacadeException {
    return groupOwnerid;
  }

  /** Return the ownerid of the group.
   *
   * @return String        group ownerid
   * @exception CalFacadeException If there's a problem
   */
  public String getOwnerid() throws CalFacadeException {
    return ownerid;
  }

  /** Return the members of the group.
   *
   * @return String        group members
   * @exception CalFacadeException If there's a problem
   */
  public String[] getMembers() throws CalFacadeException {
    return members;
  }
}
