package edu.washington.cac.calenv;

import edu.washington.cac.calenv.CalEnv;
import edu.washington.cac.calenv.CalEnvException;

import java.sql.Connection;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import java.sql.DriverManager;
import org.apache.log4j.Logger;

/** An implementation of CalEnv which obtains all the required properties
 * from a properties file.
 *
 * <p>This version gets jdbc connections directly. We will switch to
 * FileDSProperties when we move to a new version of jboss. The XAAPool
 * implementation is broken on 2.4.7
 */
public class FileJdbcProperties extends CalEnv {
  private boolean debug;

  /* ====================================================================
   *              Implementations of the abstract methods
   * ==================================================================== */

  /** Called after we obtain the object.
   *
   * @param debug     boolean true for debugging
   */
  public void init(boolean debug) throws CalEnvException {
    /* Nothing more to do here - we just take the properties fom the
       supercalsses resource file. */
    this.debug = debug;
  }

  /** Method which provides an application or site specific way to set the
   * properties. The parameter object may be used by the implementing class
   * to obtain run-time properties.
   *
   * <p>It will be called early in a web-session with the servlet.
   * This allows the CalEnv class to retrieve run-time values from the web
   * environment if required.
   *
   * <p>Alternatively, in a j2ee environment, it may ignore the call(s) to
   * initProperties and set up all its values from the deployment descriptor.
   *
   * @param val      Object implementation specific but will be called at least
   *                    once with a Servlet
   */
  public void initProperties(Object val) throws CalEnvException {
    // Do nothing. It all came from the properties file.
  }

  /** Returns a Connection object for database interactions.
   *
   * @return Connection  to the database.
   */
  public Connection getConnection() throws CalEnvException {
    try {
      Class c = Class.forName(getJdbcClassName());
      if (c == null) {
        throw new CalEnvException("Unable to load class " +
                                  getJdbcClassName());
      }

      return DriverManager.getConnection(getJdbcUrl(),
                                         getJdbcId(),
                                         getJdbcPw());
    } catch (Throwable t) {
      t.printStackTrace();
      throw new CalEnvException(t.getMessage());
    }
  }

  /** Return the class name for jdbc connections
   *
   * @return String    className
    */
  public String getJdbcClassName() {
    return pr.getProperty("org.cal.jdbcclassname");
  }

  /** Return the url for jdbc connections
   *
   * @return String    url
    */
  public String getJdbcUrl() {
    return pr.getProperty("org.cal.jdbcurl");
  }

  /** Return the userid for jdbc connections
   *
   * @return String    userid
    */
  public String getJdbcId() {
    return pr.getProperty("org.cal.jdbcid");
  }

  /** Return the password for jdbc connections
   *
   * @return String    pw
    */
  public String getJdbcPw() {
    return pr.getProperty("org.cal.jdbcpw");
  }
}

