package edu.washington.cac.calenv;

import java.sql.Connection;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;

/** An implementation of CalEnv which obtains all the required properties
 * from a properties resource file but uses a DataSource.
 */
public class FileDSProperties extends CalEnv {
  private boolean debug;

  /* ====================================================================
   *              Implementations of the abstract methods
   * ==================================================================== */

  /** Called after we obtain the object.
   *
   * @param debug     boolean true for debugging
   */
  public void init(boolean debug) throws CalEnvException {
    /* Nothing more to do here - we just take the properties fom the
       supercalsses resource file. */
    this.debug = debug;
  }

  /** Method which provides an application or site specific way to set the
   * properties. The parameter object may be used by the implementing class
   * to obtain run-time properties.
   *
   * <p>It will be called early in a web-session with the servlet.
   * This allows the CalEnv class to retrieve run-time values from the web
   * environment if required.
   *
   * <p>Alternatively, in a j2ee environment, it may ignore the call(s) to
   * initProperties and set up all its values from the deployment descriptor.
   *
   * @param val         implementation specific but will be called at least
   *                    once with a Servlet
   */
  public void initProperties(Object val) throws CalEnvException {
    // Do nothing. It all came from the properties file.
  }

  /** Returns a Connection object for database interactions.
   *
   * @return Connection  to the database.
   */
  public Connection getConnection() throws CalEnvException {
    /** This gets a resource from the container.
     * In the web.xml file you need something like:
     *  <!-- JDBC DataSources (java:comp/env/jdbc) -->
     *  <resource-ref>
     *    <description>The Calendar DS</description>
     *    <res-ref-name>jdbc/CalDB</res-ref-name>
     *    <res-type>javax.sql.DataSource</res-type>
     *    <res-auth>Container</res-auth>
     *  </resource-ref>
     *
     */

    try {
      InitialContext ctx = new InitialContext();

      DataSource ds = (DataSource) ctx.lookup("java:comp/env/jdbc/calDB");


      return ds.getConnection();
    } catch (Throwable t) {
      t.printStackTrace();
      throw new CalEnvException(t.getMessage());
    }
  }
}

