// java

package edu.washington.cac.calendar.filter;

//import edu.washington.cac.calendar.CalParameter;
import edu.washington.cac.calendar.data.Event;

/**
  A filter that selects all events

  @author Greg Barnes
  @version 1.0
 */
public class SelectAllFilter extends Filter
{
  public static final String INTERNAL_NAME = "all";

  /**
    @return true (matches all events)
    @param e Ignored
   */
  public boolean match(Event e)
  {
    return true;
  }

  /**
    Get a human-readable name for the calendar represented by the filter
    @return a human-readable name for the calendar represented by the filter
   */
  public String getName()
  {
    return "";
  }

  /**
    Get an internal name for the calendar represented by the filter
    @return an internal name for the calendar represented by the filter
   */
  public String getInternalName()
  {
    return INTERNAL_NAME;
  }
}
