// java

package edu.washington.cac.calendar.filter;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

import edu.washington.cac.calendar.data.Event;

/**
  A filter that is composed of a boolean OR of zero or more calendars

  @author Greg Barnes
  @version 2.0
 */
public class OrFilter extends NamedFilter
{
  public OrFilter(String name)
  {
    super(name);
  }

  /** 
    @return If the filter selects the event
    @param e Event to test
   */
  public boolean match(Event e)
  {
    Iterator i = getChildren().iterator();

    while (i.hasNext()) {
      if (((Calendar) i.next()).getFilter().match(e)) {
        return true;
      }
    }

    return false;
  }
}
