// java

package edu.washington.cac.calendar.filter;

import edu.washington.cac.calendar.data.Event;
import edu.washington.cac.calendar.data.NoSuchItemException;

/**
  A filter that is the boolean NOT of a calendar

  @author Greg Barnes
  @version 1.1
 */
public class NotFilter extends NamedFilter
{
  /** Id of the calendar to negate */
  private int calendarid;

  /**
    Create a new instance
    @param name Name of the filter
    @param calendarid Calendar to negate
   */
  public NotFilter(String name, int calendarid)
  {
    super(name);
    this.calendarid = calendarid;
  }

  /**
    @return If the filter selects the event
    @param e Event to test
   */
  public boolean match(Event e)
  {
    try {
      return !(PublicCalendars.getPublicCalendars().
               getCalendar(this.calendarid).getFilter().match(e));
    } catch (NoSuchItemException ex) {
      throw new RuntimeException("Can't find underlying calendar with id " +
                                 this.calendarid);
    }
  }

  /**
    Should the children of this calendar be displayed?
    @return false
   */
  public boolean showChildren()
  {
    return false;
  }
}
