// java

package edu.washington.cac.calendar.filter;

import edu.washington.cac.calendar.data.Event;

/**
  A filter that selects no events

  @author Greg Barnes
  @version 1.0
 */
public class NoFilter extends Filter
{
  /** 
    Does the filter select the event?
    @return If the filter selects the event
    @param e Event to test
   */
  public boolean match(Event e)
  {
    return false;
  }

  /**
    Get a human-readable name for the calendar represented by the filter
    @return a human-readable name for the calendar represented by the filter
   */
  public String getName()
  {
    return "nothing";
  }

  /**
    Get an internal name for the calendar represented by the filter.
    This name can be passed along as a form parameter, for example, and
    used to reconstruct the filter.
    @return an internal name for the calendar represented by the filter
   */
  public String getInternalName()
  {
    return getName();
  }

  /**
    Is this filter the same as another object?
    @param o Object to check against
    @return Is this filter the same as the object?
   */
  public boolean equals(Object o)
  {
    return o instanceof NoFilter;
  }
}
