// java

package edu.washington.cac.calendar.filter;

/**
  A filter that is named

  @author Greg Barnes
  @version 2.0
 */
public abstract class NamedFilter extends Filter
{
  /** The name of the filter */
  private String name;

  /**
    Create a new instance
    @param name Name of the filter
   */
  NamedFilter(String name)
  {
    this.name = name;
  }

  /**
    Get a human-readable name for the calendar represented by the filter
    @return a human-readable name for the calendar represented by the filter
   */
  public String getName()
  {
    return this.name;
  }

  /**
    Get an internal name for the calendar represented by the filter
    @return an internal name for the calendar represented by the filter
   */
  public String getInternalName()
  {
    return this.name;
  }
}
