// java

package edu.washington.cac.calendar.filter;

import edu.washington.cac.calendar.data.Event;
import edu.washington.cac.calendar.data.Keyword;
import edu.washington.cac.calendar.data.NoSuchItemException;
import edu.washington.cac.calendar.data.PublicEvents;
import edu.washington.cac.calendar.data.User;

/**
  A filter that selects events that have a certain keyword

  @author Greg Barnes
  @version 1.0
 */
public class KeywordFilter extends Filter
{
  public static final String INTERNAL_NAME = "kw";

  /** The keyword to match */
  private Keyword k;

  /**
    Create a new instance
    @param id Id of the Keyword to match
    @exception NoSuchItemException if there is no such keyword
   */
  public KeywordFilter(int id) throws NoSuchItemException
  {
    this.k = PublicEvents.getPublicKeywords().getKeyword(id);
  }

  /**
    Create a new instance
    @param k Keyword to match
   */
  public KeywordFilter(Keyword k)
  {
    this.k = k;
  }

  /**
    @return If the filter selects the event
    @param e Event to test
   */
  public boolean match(Event e)
  {
    return e.hasKeyword(k);
  }

  /**
    Get an internal name for the calendar represented by the filter
    @return an internal name for the calendar represented by the filter
   */
  public String getInternalName()
  {
//    return CalParameter.KEYWORD + this.k.getId();
    return INTERNAL_NAME + this.k.getId();
  }

  /**
    Get a human-readable name for the calendar represented by the filter
    @return a human-readable name for the calendar represented by the filter
   */
  public String getName()
  {
    return this.k.getWord();
  }
}
