// java

package edu.washington.cac.calendar.filter;

import java.sql.SQLException;

import edu.washington.cac.calendar.data.Event;
import edu.washington.cac.calendar.data.NoSuchItemException;
import edu.washington.cac.calendar.data.User;
import edu.washington.cac.calendar.db.Caldata;

/**
  A filter that selects all events created by a particular user

  @author Greg Barnes
  @version 1.0
 */
public class CreatorFilter extends Filter
{
  /** User whose events we want to see */
  private User creator;

  /**
    Create a new instance
    @param creator User whose events we want to see
   */
  public CreatorFilter(User creator)
  {
    this.creator = creator;
  }
  
  /**
    Create a new instance
    @param userid Id of the user whose events we want to see
    @exception SQLException If we have trouble finding out the corresponding
      name of the user
    @exception NoSuchItemException If no such user exists
   */
  public CreatorFilter(int userid) throws SQLException, NoSuchItemException
  {
    this(new User(new Caldata().getUsername(userid)));
  }

  /** 
    @return true if the event was created by the user
    @param e Event to test
   */
  public boolean match(Event e)
  {
    return e.getCreator().equals(this.creator);
  }

  /**
    Get a human-readable name for the calendar represented by the filter
    @return a human-readable name for the calendar represented by the filter
   */
  public String getName()
  {
    return "Events created by " + this.creator;
  }

  /**
    Get an internal name for the calendar represented by the filter
    @return an internal name for the calendar represented by the filter
   */
  public String getInternalName()
  {
    return getName();
  }

  /** 
    Get the creator we're filtering on
    @return the creator we're filtering on
   */
  User getCreator()
  {
    return this.creator;
  }
}
