package edu.washington.cac.calendar.filter;

import java.sql.SQLException;

//import edu.washington.cac.calendar.CalParameter;
import edu.washington.cac.calendar.data.DBObject;
import edu.washington.cac.calendar.data.EntityRef;
import edu.washington.cac.calendar.data.User;
import edu.washington.cac.calendar.db.Caldata;

/**
  Represents a selection of a public calendar by a particular user.
  Also known as a subscription.

  @author Greg Barnes
  @version 1.0
 */
public class CalendarRef extends EntityRef
{
  /**
   Create a CalendarRef for a user
   @param id id of the calendar
   @param user user
   */
  public CalendarRef(int id, User user)
  {
    super(id, user);
  }

  /**
   Create a CalendarRef for a user
   @param cp Http Parameters, presumably including a calendarid
   @param user User to create the eventref for
   *//*
  public CalendarRef(CalParameter cp, User user)
  {
    this(cp.getCalendar(), user);
  }*/

  /**
    Add subscription to db.
    @return Whether the add changed one row in the database
    @exception SQLException If there's a database error
   */
  public boolean add() throws SQLException
  {
//    this.log.println("adding subscription to calendar #" + getId() +
//                     " for user " + getUser().getName());
    return getCaldata().addSubscription(this) == 1;
  }

  /**
    Remove subscription from the db
    @exception SQLException If there's a database error
   */
  public void delete() throws SQLException
  {
//    this.log.println("deleting subscription to calendar #" + getId() +
//                     " for user " + getUser().getName());
    getCaldata().deleteSubscription(this);
  }

  /**
    Does this reference represent an individual entity?
    @return does this reference represent an individual entity?
   */
  public boolean isSingleEntity()
  {
    return false;
  }
}
