// java

package edu.washington.cac.calendar.filter;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

import edu.washington.cac.calendar.data.Event;

/**
  A filter that is composed of a boolean AND of zero or more calendars

  @author Greg Barnes
  @version 1.0
 */
public class AndFilter extends NamedFilter
{
  public AndFilter(String name)
  {
    super(name);
  }

  /** 
    @return If the filter selects the event
    @param e Event to test
   */
  public boolean match(Event e)
  {
    Iterator i = getChildren().iterator();

    while (i.hasNext()) {
      if (!(((Calendar) i.next()).getFilter().match(e))) {
        return false;
      }
    }

    return true;
  }

  /**
    Should the children of this calendar be displayed?
    @return false
   */
  public boolean showChildren()
  {
    return false;
  }
}
