// java

package edu.washington.cac.calendar.db;

import java.util.Enumeration;
import java.util.Vector;

/** a where clause
  @author Greg Barnes
  @version 1.3
 */
class WhereClause {
  private Vector clauses = new Vector();

  WhereClause() {
  }
    
  WhereClause(String[] clauseArray) {
    addClauses(clauseArray);
  }

  WhereClause addClauses(String[] clauseArray) {
    int i;

    for (i = 0; i < clauseArray.length; i++) {
      addClause(clauseArray[i]);
    }

    return this;
  }

  WhereClause addClause(String c) {
    clauses.addElement(c);
    return this;
  }
  
  /**
    Add another WhereClause to this WhereClause
    @param clause WhereClause to add
   */
  WhereClause addClause(WhereClause clause)
  {
    addClause(clause.subclauses());
    return this;
  }
  
  static final String AND = " and ";

  /** @return a string representation of all the subclauses */
  public String subclauses() 
  {
    Enumeration e = clauses.elements();

    if (!e.hasMoreElements()) {
      return "";
    } else {
      StringBuffer sb = new StringBuffer((String) e.nextElement());

      while (e.hasMoreElements()) {
        sb.append(AND);
        sb.append((String) e.nextElement());
      }

      return sb.toString();
    }
  }

  /** @return a string representatin of the where clause */
  public String toString() 
  {
    return (subclauses().length() > 0 ? "where " : "") + subclauses();
  }
}
