//java

package edu.washington.cac.calendar.db;

/** A varchar field in the database
    @author Greg Barnes
    @version 1.0
  */
public class VarcharField extends SimpleField {
  /** The maximum number of characters allowed in the field */
  protected int maxLength;

  /** Specify a varchar field in the database
    @param name Name of the field in the database
    @param table Name of the table the field appears in
    @param maxLength Maximum number of characters allowed
   */
  protected VarcharField(String name, SimpleTable table, int maxLength) {
    super(name, table);
    this.maxLength = maxLength;
  }

  /** Get the maximum number of characters allowed
    @return The maximum number of characters allowed
   */
  public int getMaxLength() {
    return maxLength;
  }

  /**
    Get the index of the last character in a String that would fit in
    this database field

    @param s The String in question
    @return int The index of the last character to fit
   */
  //%%% This is set up to work for a particular DB driver, and may
  //%%% need to be modified for others
  protected int indexOfLastDBChar(String s) {
    return fitStringToBuffer(s, maxLength);
  }

  /** Size a String so that it fits in the field
    @param s The string to size
    @return the string, truncated to fit
   */
  public String sizeToFit(String s) {
    return (s == null) ? s : s.substring(0, indexOfLastDBChar(s) + 1);
  }


  /** *************************************
      Following cloned from myuw.util.MyUWURLCoder
      *************************** */

  public static final char sq = 0x27;
  public static final char dq = 0x22;
  public static final char op = 0x28;
  public static final char cp = 0x29;
  public static final char cr = 0x0A;
  public static final char lf = 0x0D;
  public static final char pct = 0x25;
  public static final char bar = 0x7c;
  public static final char tab = 0x9c;

  /**
   * Utility method that returns the index of the last character in
   * the input string that will fit in a buffer of the size specified.
   * <P>
   * This method assumes that URL encoding is being used.  As a result
   * of this assumption, every encodable character increases the size
   * of the output string by 2 bytes, hence the appearance of the
   * magic number 2 in the body of the method
   *
   *@param s the input string
   *@param bufferSize the buffer size
   *@return the index of the leftmost character in
   *  <code>s</code> that will fit in a buffer
   *  of size <code>bufferSize</code> after it is encoded
   */
  public static int fitStringToBuffer(String s, int bufferSize)
    throws IllegalArgumentException
  {
    int i, outSize = 0;

    if( s == null ) {
      throw new IllegalArgumentException(
        "VarcharField: fitStringToBuffer, null argument");
    }

    for(i=0; i<s.length(); i++) {
      if( isEncodeable(s.charAt(i) )) {
        outSize += 3;
      } else {
        outSize++;
      }

      if (outSize > bufferSize) {
        return i-1;
      }
    }

      // last char in s will fit; its index is s.length() - 1
    return s.length() - 1;
  }

  /** Return true if the specified character is one that needs to be encoded */
  public static boolean isEncodeable( char ch )
  {
    boolean result;

    switch(ch)
    {
      case sq:
      case dq:
      case op:
      case cp:
      case cr:
      case lf:
      case pct:
      case tab:
      case bar:
        result = true;
        break;

      default:
        result = false;
        break;
    }

    return result;
  }

  /** Test the sizeToFit method
    @param args ignored
   */
  public static void main(String[] args) {
    VarcharField v = new VarcharField("x", new SimpleTable("x", "x"), 20);
    System.out.println(v.sizeToFit("01234567890123456789"));
    System.out.println(v.sizeToFit("012345678901234567890"));
    System.out.println(v.sizeToFit(null));
    System.out.println(v.sizeToFit(""));
    System.out.println(v.sizeToFit("0"));
    System.out.println(v.sizeToFit("%%%%%%%%%%%%%%%%%%%%%%%%%%%"));
  }
}
