//java

package edu.washington.cac.calendar.db;

//import java.sql.*;

/** The tables in the database
  @author Greg Barnes
  @version 1.2
 */
public class Tables 
{
  /** qualify a field name with a table name
    @param tableName the name of the table
    @param fieldName the name of the field
    @return the qualified field name
   */
  static String qualify(String tableName, String fieldName) 
  {
    return tableName + "." + fieldName;
  }

  /** alias a field name with a table alias
    @param tableAlias the alias of the table
    @param fieldName the name of the field
    @return the aliased field name
   */
  static String alias(String tableAlias, String fieldName) 
  {
      return tableAlias + fieldName;
  }

  /** database name of the events table */
  static final String EVENTS_TABLE = "events";

  /** database name of the keywords table */
  static final String KEYWORDS_TABLE = "keywords";

  /** database name of the sponsors table */
  static final String SPONSORS_TABLE = "sponsors";

  /** database name of the locations table */
  static final String LOCATIONS_TABLE = "locations";

  /** database name of the event/keywords table */
  static final String EVENTKEYWORDS_TABLE = "event_keywords";

  /** database name of the users table */
  static final String USERS_TABLE = "users";

  /** database name of the eventrefs table */
  static final String EVENTREFS_TABLE = "eventrefs";

  /** database name of the master/details table */
  static final String MASTERDETAILS_TABLE = "master_details";

  /** database name of the authorization table */
      //  static final String AUTH_TABLE = "authorization";
  static final String AUTH_TABLE = "auth";

  /** database name of the calendars table */
  static final String CALENDARS_TABLE = "calendars";

  /** database name of the subscriptions table */
  static final String SUBSCRIPTIONS_TABLE = "subscriptions";

  /** database name of the red alerts table */
  static final String REDALERTS_TABLE = "redalerts";

  /** database name of the marked events table */
  static final String MARKEDEVENTS_TABLE = "markedevents";

  /** alias for the events table */
  static final String EVENTS_ALIAS = "e";

  /** alias for the keywords table */
  static final String KEYWORDS_ALIAS = "k";

  /** alias for the sponsors table */
  static final String SPONSORS_ALIAS = "s";

  /** alias for the locations table */
  static final String LOCATIONS_ALIAS = "l";

  /** alias for the event/keywords table */
  static final String EVENTKEYWORDS_ALIAS = "ek";

  /** alias for the users table */
  static final String USERS_ALIAS = "u";

  /** alias for the eventrefs table */
  static final String EVENTREFS_ALIAS = "er";

  /** alias for the master/details table */
  static final String MASTERDETAILS_ALIAS = "md";

  /** alias for the authorization table */
  static final String AUTH_ALIAS = "a";

  /** alias for the calendars table */
  static final String CALENDARS_ALIAS = "c";

  /** alias for the subscriptions table */
  static final String SUBSCRIPTIONS_ALIAS = "su";

  /** alias for the red alerts table */
  static final String REDALERTS_ALIAS = "r";

  /** alias for the marked events table */
  static final String MARKEDEVENTS_ALIAS = "me";

  /** The events table */
  public static SimpleTable EVENTS = 
    new SimpleTable(EVENTS_TABLE, EVENTS_ALIAS);

  /** The keywords table */
  public static SimpleTable KEYWORDS = 
    new SimpleTable(KEYWORDS_TABLE, KEYWORDS_ALIAS);

  /** The sponsors table */
  public static SimpleTable SPONSORS = 
    new SimpleTable(SPONSORS_TABLE, SPONSORS_ALIAS);

  /** The locations table */
  public static SimpleTable LOCATIONS = 
    new SimpleTable(LOCATIONS_TABLE, LOCATIONS_ALIAS);

  /** The event/keywords table */
  public static SimpleTable EVENTKEYWORDS = 
    new SimpleTable(EVENTKEYWORDS_TABLE, EVENTKEYWORDS_ALIAS);

  /** The users table */
  public static SimpleTable USERS = 
    new SimpleTable(USERS_TABLE, USERS_ALIAS);

  /** The eventrefs table */
  public static SimpleTable EVENTREFS = 
    new SimpleTable(EVENTREFS_TABLE, EVENTREFS_ALIAS);

  /** The eventrefs table */
  public static SimpleTable MASTERDETAILS = 
    new SimpleTable(MASTERDETAILS_TABLE, MASTERDETAILS_ALIAS);

  /** The authorization table */
  public static SimpleTable AUTH = 
    new SimpleTable(AUTH_TABLE, AUTH_ALIAS);

  /** The calendars table */
  public static SimpleTable CALENDARS = 
    new SimpleTable(CALENDARS_TABLE, CALENDARS_ALIAS);

  /** The subscriptions table */
  public static SimpleTable SUBSCRIPTIONS = 
    new SimpleTable(SUBSCRIPTIONS_TABLE, SUBSCRIPTIONS_ALIAS);

  /** The red alerts table */
  public static SimpleTable REDALERTS = 
    new SimpleTable(REDALERTS_TABLE, REDALERTS_ALIAS);

  /** The marked events table */
  public static SimpleTable MARKEDEVENTS = 
    new SimpleTable(MARKEDEVENTS_TABLE, MARKEDEVENTS_ALIAS);

  /** test: print out the statement to select all fields, for all tables 
    @param args (ignored)
   */
  public static void main(String[] args) {
    Fields x = new Fields();

    System.err.println(EVENTS.selectClause());
    System.err.println(KEYWORDS.selectClause());
    System.err.println(SPONSORS.selectClause());
    System.err.println(LOCATIONS.selectClause());
    System.err.println(EVENTKEYWORDS.selectClause());
    System.err.println(USERS.selectClause());
    System.err.println(EVENTREFS.selectClause());
    System.err.println(MASTERDETAILS.selectClause());
    System.err.println(AUTH.selectClause());
    System.err.println(CALENDARS.selectClause());
    System.err.println(SUBSCRIPTIONS.selectClause());
    System.err.println(REDALERTS.selectClause());
    System.err.println(MARKEDEVENTS.selectClause());
  }
}
