//java

package edu.washington.cac.calendar.db;

  /** An object representing a 'table' that a result set might return
        @author Greg Barnes
        @version 1.0
    */
public class Table {
  /** The name of the table */
  private String name;
    protected Field[] fields;

    protected Table(String name, Field[] fields) {
        this.name = name;
        this.fields = fields;
    }

  /** @return The name of the table */
  public String getName() {
    return this.name;
  }

  /** @return a printable version of the table */
  public String toString() {
    return this.name;
  }

    Field[] getFields() {
        return fields;
    }

    void setFields(Field[] fields) {
        this.fields = fields;
    }

  /** @return a field as it should appear in a select statement
      @param field The field name
    */
  protected String selectName(Field field)
  {
    return field.getSelectName();
  }

  /** @return The table name as it should appear in a from clause */
  protected String fromName()
  {
    return this.name;
  }

    private static final String SELECT_START = "select ";
    private static final String FROM_START = " from ";

  /** @return The Select clause containing all the fields in the table */
  String selectClause() 
  {
    StringBuffer s = new StringBuffer(SELECT_START);
    int i;

    for (i = 0; i < fields.length; i++) {
      if (i != 0) { 
        s.append(", ");
      }

      s.append(selectName(fields[i]));
    }

    s.append(FROM_START);
    s.append(fromName());
    return s.toString();
  }
}
