//java

package edu.washington.cac.calendar.db;

  /** An object representing a table in the database
        @author Greg Barnes
        @version 1.0
    */
public class SimpleTable extends Table {
  private String aliasName;

    protected SimpleTable(String name, String aliasName) {
        super(name, null);
        this.aliasName = aliasName;
    }

  /** @return the aliasName */
  protected String getAliasName()
  {
    return this.aliasName;
  }

  /** Qualify a single field with the table name

    @param fieldName The name of the field to qualify
    @returns The field name qualified by the table name
    */
  protected String qualify(String fieldName) {
    return Tables.qualify(getName(), fieldName);
  }

      /** Alias a single field with the table alias

        @param i number of the field to qualify
        @returns The field name aliased by the table alias
        */
    protected String alias(String fieldName) {
        return Tables.alias(this.aliasName, fieldName);
    }
}
