//java

package edu.washington.cac.calendar.db;

  /** A field in the database that can be qualified or aliased
        @author Greg Barnes
        @version 1.0
    */
public class SimpleField extends Field {
    private static final SimpleTable DUMMY = new SimpleTable("dummy", "dummy");

    protected SimpleTable table = DUMMY;

    protected SimpleField(String name, SimpleTable table) {
        super(name);
        this.table = table;
    }

      // name qualified by table
    private String getQualifiedName() {
        return table.qualify(name);
    }

    private String getAliasedName() {
        return table.alias(name);
    }

      // the name as it should be referred to in a result set
    public String getName() {
        return getAliasedName();
    }

      /* the name as it should be referred to in a statement (select, where
         clause, etc.
       */
    public String getStmtName() {
        return getQualifiedName();
    }

  /**
    The field as it should appear in a select statement
    @return The field suitable for a select statement
   */
  public String getSelectName() {
    return getQualifiedName() + " as " + getAliasedName();
  }
}
