//java

package edu.washington.cac.calendar.db;

  /** An object representing a query to the database
	@author Greg Barnes
	@version 1.0
    */
public class Query {
    protected Table t;
    protected WhereClause where;
    protected OrderBy orderBy;

    private static final OrderBy NO_ORDER_BY = new OrderBy();
  
    protected Query(Table t,
			WhereClause where)
    {
	this(t, where, NO_ORDER_BY);
    }

    protected Query(Table t,
			WhereClause where,
			OrderBy orderBy) 
    {
	this.t = t;
	this.where= where;
	this.orderBy = orderBy;
    }

    public String toString() {
	StringBuffer s = new StringBuffer(t.selectClause());
	s.append(" ");
	s.append(where.toString());
	s.append(" ");
	s.append(orderBy.toString());
	return s.toString();
    }
}
