// java

package edu.washington.cac.calendar.db;

import java.util.*;

  /** an "order by" clause in a query
	@author Greg Barnes
	@version 1.0
    */
class OrderBy {
    private Vector fields = new Vector();

    OrderBy() {
    }
    
    OrderBy(Field[] fieldArray) {
	addFields(fieldArray);
    }

    OrderBy addFields(Field[] fieldArray) {
	int i;

	for (i = 0; i < fieldArray.length; i++) {
	    addField(fieldArray[i]);
	}

	return this;
    }
    
    OrderBy addField(Field f) {
	fields.addElement(f);
	return this;
    }
    
    public String toString() {
	Enumeration e = fields.elements();
	boolean firstElement = true;

	if (!e.hasMoreElements()) {
	    return "";
	} else {
	    StringBuffer sb = new StringBuffer("order by ");
	    sb.append(((Field) e.nextElement()).getStmtName());

	    while (e.hasMoreElements()) {
	        sb.append(", ");
	        sb.append(((Field) e.nextElement()).getStmtName());
	    }

	    return sb.toString();
	}
    }
}
