// java

package edu.washington.cac.calendar.db;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;

/**
  Load a set of calendars into the calendars table

  @author Greg Barnes
  @version 1.0
 */
public class LoadCalendars
{
  /** 
      Load the calendars from a file into the database 
      @param args The name of the file
      @exception IOException If there's a problem reading the file
      @exception SQLException If there's a problem with the database
    */
  public static void main(String[] args) throws IOException, SQLException
  {
    if (args.length != 1) {
      System.err.println("Usage: LoadCalendars <filename>");
      return;
    }

    BufferedReader in = new BufferedReader(new FileReader(args[0]));

    for (String s = in.readLine(); s != null; s = in.readLine()) {
      if (s.startsWith("#") || s.trim().length() == 0) {    // comment line
        continue;               
      } 

      s = s.substring(s.indexOf("("), s.lastIndexOf(")") + 1);
      System.out.println(s);
      new Caldata().addCalendar(s);
    }
  }
}
