//java

package edu.washington.cac.calendar.db;

  /** A field in the database
        @author Greg Barnes
        @version 1.0
    */
public class Field {
    protected String name;

    protected Field(String name) {
        this.name = name;
    }

    protected String getBaseName() {
        return name;
    }

      // the name as it should be referred to in a result set
    public String getName() {
        return getBaseName();
    }

  /** the name as it should be referred to in a statement (e.g., in a
      where clause, etc.
      @return the name of the field as it should be in a statement
   */
  public String getStmtName() {
    return getBaseName();
  }

  /** the name as it should be referred to in the list of fields in
     a select statement
      @return the name of the field as it should be in the list of fields
        in a select statement
   */
  public String getSelectName() {
    return getBaseName();
  }

  /** @return the name of the field as it should be in the list of fields
      in an insert statement
   */
  public String getInsertName() {
    return getBaseName();
  }
}
