// java

package edu.washington.cac.calendar.db;

import edu.washington.cac.calendar.data.User;
import edu.washington.cac.calenv.CalEnv;

/**
  Provides access to specific db information, such as the JDBC driver used,
  the URL to access the db, etc.

  @author Greg Barnes
  @version 3.0
 */
public class DBResources {
  private static CalEnv env;

  private static CalEnv getEnv() {
    if (env == null) {
      try {
        env = CalEnv.getEnv();
      } catch (Throwable t) {
        t.printStackTrace();
      }
    }

    return env;
  }

  /** @return A user used to create special entries in the database,
      such as default Locations and Sponsors that should always exist.
   */
  public static User specialCreator() {
    try {
      return new User(getEnv().specialCreator());
    } catch (Throwable t) {
      // Can't do much at the moment. Try to halt things here
      t.printStackTrace();
      throw new RuntimeException("Calendar exception: " + t.getMessage(),
                                 t);
    }
  }

  /**
    The user used to create keywords that can be used with official
    public events.

    @return The user used to create keywords that can be used with official
    public events.
   */
  public static User officialKeywordCreator() {
    try {
      return new User(getEnv().officialKeywordCreator());
    } catch (Throwable t) {
      // Can't do much at the moment. Try to halt things here
      t.printStackTrace();
      throw new RuntimeException("Calendar exception: " + t.getMessage(),
                                 t);
    }
  }

  /**
    The user used to create keywords that can be used with unofficial
    public events.

    @return The user used to create keywords that can be used with unofficial
    public events.
   */
  public static User unofficialKeywordCreator() {
    try {
      return new User(getEnv().unofficialKeywordCreator());
    } catch (Throwable t) {
      // Can't do much at the moment. Try to halt things here
      t.printStackTrace();
      throw new RuntimeException("Calendar exception: " + t.getMessage(),
                                 t);
    }
  }

  /**
    The user used to create public entities that should not be loaded by
    default

    @return The user used to create public entities that should not be
    loaded by default
   */
  public static User notToBeLoadedByDefaultCreator() {
    try {
      return new User(getEnv().notToBeLoadedByDefaultCreator());
    } catch (Throwable t) {
      // Can't do much at the moment. Try to halt things here
      t.printStackTrace();
      throw new RuntimeException("Calendar exception: " + t.getMessage(),
                                 t);
    }
  }
}
