//java

package edu.washington.cac.calendar.db;

/** An object representing a table in the database
    where the table name is aliased
    @author Greg Barnes
    @version 1.0
  */
public class AliasedTable extends SimpleTable {
  protected AliasedTable(String name, String aliasName) {
    super(name, aliasName);
  }

  /** Qualify a single field with the table name

    @param i number of the field to qualify
    @returns The field name qualified by the table name
   */
  protected String qualify(String fieldName) {
    return Tables.qualify(getAliasName(), fieldName);
  }

  /** @return a field as it should appear in a select statement
      @param field The field name
    */
  protected String selectName(Field field)
  {
    return field.getStmtName();
  }

  protected String fromName()
  {
    return getName() + " as " + getAliasName();
  }
}
