// java

package edu.washington.cac.calendar.data;

import edu.washington.cac.calendar.db.Caldata;

import java.sql.SQLException;

import org.apache.log4j.Logger;

public class Sponsors extends Cache implements CacheI
{
  /** Create a set of sponsors for a particular user
    @param user The user
    @param load Should we load up the set now?
    @exception SQLException if we can't load the set from the database
    @exception ItemException if the set contains bad data
   */
  public Sponsors(User user, boolean load)
      throws SQLException, ItemException
  {
    super(user, load);
//    addDummy();         // insure dummy sponsor is always there
  }

  /** Create a set of sponsors for a particular user, without loading
    @param user The user
   */
  public Sponsors(User user)
  {
    super(user);
//    addDummy();         // insure dummy sponsor is always there
  }

  /** Create a set of sponsors for the guest, without loading
   */
  public Sponsors()
  {
    this(new User());
  }

  /* * Add a dummy sponsor to the set * /
  private void addDummy()
  {
    if (!hash.containsKey(key(Sponsor.DUMMY_SPONSOR))) {
      try {
        localAdd(Sponsor.DUMMY_SPONSOR);
      } catch (ItemAccessException e) {  // shouldn't happen
        Logger.getLogger(this.getClass()).error(
              "Couldn't add dummy sponsor!", e);
        throw new RuntimeException("Couldn't add dummy sponsor!");
      }
    }
  } */

  /**
    Fill up the cache
    @exception SQLException if we can't load the set from the database
    @exception ItemException if the set contains bad data
   */
  protected void doLoadAll() throws SQLException, ItemException
  {
    getCaldata().loadSponsors(user, this);
  }

  /**
    get a sponsor with a given id

    @param sponsorId the id of the sponsor
    @return the sponsor in question
    @exception NoSuchItemException if the sponsor does not exist
   */
  public Sponsor getSponsor(int sponsorId) throws NoSuchItemException
  {
    return (Sponsor) get(sponsorId);
  }

  /**
    Load a single sponsor into the cache
    @param id Id of the item to load
    @exception SQLException If there's a problem accessing the database
    @exception CaldataException If there's a problem with the data in the db
    @exception NoSuchItemException If the item does not exist
    @exception ItemAccessException If the item can't be added to the cache
   */
  protected void loadOne(int id)
      throws SQLException, CaldataException, NoSuchItemException,
             ItemAccessException
  {
    getCaldata().loadOneSponsor(id, this);
  }
}
