// java

package edu.washington.cac.calendar.data;

import java.util.Enumeration;
import java.util.Vector;

public class SortedEvents {
    private Vector v = new Vector();

    SortedEvents(Enumeration e) {
	while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
	}

	sort();
    }

    private void sort() {
	sort(0, v.size() - 1);
    }

    private static final int THRESHHOLD = 5;

    private void sort(int start, int end) {
	if (end - start > THRESHHOLD) {
	    quickSort(start, end);
	} else {
	    bubbleSort(start, end);
	}
    }

    private void bubbleSort(int top, int bottom) {
//System.err.println("bubbleSort: " + top + ":" + bottom);
	int i, j;
	boolean swapDone;

	for (i = top; i < bottom; i++) {
	    swapDone = false;

	    for (j = bottom; j > i; j--) {
		if (lessThan((Event) v.elementAt(j), (Event) v.elementAt(j-1)))
	 	{
    		    swapElementsAt(j, j - 1);
		    swapDone = true;
		}
	    }

	    if (!swapDone) {
		break;
	    }
	}
    }
	
    private void swapElementsAt(int i, int j) {
	Object o = v.elementAt(i);
	v.setElementAt(v.elementAt(j), i);
	v.setElementAt(o, j);
    }

    private boolean lessThan(Event e1, Event e2) {
	return e1.lessThan(e2);
    }

    private boolean greaterThan(Event e1, Event e2) {
	return lessThan(e2, e1);
    }

    private int leftmostNotLessThanPivot(int start, int end, Event pivot) {
	int i;

	for (i = start; i <= end && lessThan((Event) v.elementAt(i), pivot); 
	  i++) 
	{
	}

	return i;
    }

    private int rightmostNotGreaterThanPivot(int start, int end, Event pivot) {
	int i;

	for (i = start; i >= end && greaterThan((Event) v.elementAt(i), pivot); 
	  i--) 
	{
	}

	return i;
    }

    private boolean nothingLeftToDo(int left, int right) {
	return emptyRange(left, right);
    }

    private boolean emptyRange(int left, int right) {
	return left >= right;
    }

      // returns proper location of pivot
    private int splitOnPivot(int left, int right) {
	Event pivot = (Event) v.elementAt(right);
	int currentLeft = left;
	int currentRight = right - 1;
//System.err.println(pivot.getShortdesc());
	int newLeft, newRight;

	while (true) {
	    newLeft = leftmostNotLessThanPivot(currentLeft, currentRight,
	      pivot);
	    newRight = rightmostNotGreaterThanPivot(currentRight, 
	      currentLeft, pivot);

	    if (nothingLeftToDo(newLeft, newRight)) {
	        break;
	    }

	    swapElementsAt(newLeft, newRight);
	    currentLeft = newLeft + 1;
	    currentRight = newRight - 1;
	}

	return newLeft;
    }

    private void quickSort(int left, int right) {
//System.err.println("quickSort: " + left + ":" + right);
	if (!nothingLeftToDo(left, right)) {
	    int properPivotIndex = 
	      splitOnPivot(left, right);
//System.err.println(properPivotIndex);
	    swapElementsAt(properPivotIndex, right);
	    sort(left, properPivotIndex - 1);
	    sort(properPivotIndex + 1, right);
	}
    }

    Enumeration elements() {
	return v.elements();
    }

    Event[] eventArray() {
	int i = 0;
	Object[] oa = new Object[v.size()];
	v.copyInto(oa);
	Event[] ea = new Event[oa.length];

	for (; i < oa.length; i++) {
	    ea[i] = (Event) oa[i];
	}

	return ea;
    }   
}
