// java

package edu.washington.cac.calendar.data;

import edu.washington.cac.calenv.CalEnv;
import edu.washington.cac.calenv.CalEnvException;

/**
  A set of access rights for a public object
  @author Greg Barnes
  @version 1.0
 */
public class PublicAccessRights extends AccessRights
{
  /** Define the various access levels administrators might have.
   * Note these are powers of two so we can add them up.
   */
  public static final int noPrivileges = 0;

  /** Not one who stays awake but one who can add alerts
   */
  public static final int alertUser = 2;

  /** A user who can add public events
   */
  public static final int publicEventUser = 64;

  /** A user who can administer anybodies content
   */
  public static final int contentAdminUser = 128;

  /** One who can do everything
   */
  public static final int superUser = 32768;

  /** Useful value.
   */
  public static final int allAuth = alertUser +
                                    publicEventUser +
                                    contentAdminUser +
                                    superUser;
  /**
    Create access rights for a public object
    @param c The public object
   */
  PublicAccessRights(CalendarObject c)
  {
    super(c);
  }

  /** Can a user read (search for, include in their cache) the object?
    @param user User to test
    @return Can the user read (search for, include in their cache) the object?
   */
  boolean canBeReadBy(User user)
  {
    return true;
  }

  //%%% Below need to be modified to handle public events entry rules.

  /**
    Can the application change public entities?
    @return Can the application change public entities?
   */
  private boolean appCanChangePublicEntities() {
    try {
      return CalEnv.getEnv().appCanChangePublicEntities(); 
    } catch (CalEnvException e) {
      /* most likely, the properties file couldn't be read.  Just log and 
         deny access.
       */
      e.printStackTrace();
      return false;
    }
  }

  /** Can a user modify the object?
    @param user User to test
    @return Can the user modify the object?
   */
  boolean canBeModifiedBy(User user)
  {
    /* Won't work while publicEvents is static
    if ((user.getRights() & superUser) != 0) {
      return true;
    }

    return isCreator(user);
    */
//    return false;
System.err.println("canBeModifiedBy " + user + ":" + appCanChangePublicEntities());
    return appCanChangePublicEntities();
  }

  /** Can a user create the object?
    @param user User to test
    @return Can the user create the object?
   */
  boolean canBeCreatedBy(User user)
  {
    /* Won't work while publicEvents is static
    if ((user.getRights() & superUser) != 0) {
      return true;
    }

    return isCreator(user);
    */
//    return false;
System.err.println("canBeCreatedBy " + user + ":" + appCanChangePublicEntities());
    return appCanChangePublicEntities();
  }

  /** Can a user delete the object?
    @param user User to test
    @return Can the user delete the object?
   */
  boolean canBeDeletedBy(User user)
  {
    /* Won't work while publicEvents is static
    if ((user.getRights() & superUser) != 0) {
      return true;
    }

    return isCreator(user);
    */
//    return false;
System.err.println("canBeDeletedBy " + user + ":" + appCanChangePublicEntities());
    return appCanChangePublicEntities();
  }
}
