// java

package edu.washington.cac.calendar.data;

/**
  A set of access rights for a private object 
  @author Greg Barnes
  @version 1.0
 */
public class PrivateAccessRights extends AccessRights
{
  PrivateAccessRights(CalendarObject c)
  {
    super(c);
  }

  /** Can a user read (search for, include in their cache) the object?
    @param user User to test
    @return Can the user read (search for, include in their cache) the object?
   */
  boolean canBeReadBy(User user)
  {
    return isCreator(user);
  }

  /** Can a user modify the object?
    @param user User to test
    @return Can the user modify the object?
   */
  boolean canBeModifiedBy(User user)
  {
    return isCreator(user);
  }

  /** Can a user create the object?
    @param user User to test
    @return Can the user create the object?
   */
  boolean canBeCreatedBy(User user)
  {
    return isCreator(user);
  }

  /** Can a user delete the object?
    @param user User to test
    @return Can the user delete the object?
   */
  boolean canBeDeletedBy(User user)
  {
    return isCreator(user);
  }
}
